/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.LifecycleState;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultVulnerabilityState;
import com.oracle.bmc.vulnerabilityscanning.model.VulnerabilityType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostVulnerabilitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="cveReference")
    private final String cveReference;
    @JsonProperty(value="severity")
    private final ScanResultProblemSeverity severity;
    @JsonProperty(value="state")
    private final ScanResultVulnerabilityState state;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="timeLastDetected")
    private final Date timeLastDetected;
    @JsonProperty(value="timeFirstDetected")
    private final Date timeFirstDetected;
    @JsonProperty(value="hostCount")
    private final Integer hostCount;
    @JsonProperty(value="vulnerabilityType")
    private final VulnerabilityType vulnerabilityType;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "cveReference", "severity", "state", "name", "timeLastDetected", "timeFirstDetected", "hostCount", "vulnerabilityType", "lifecycleState"})
    public HostVulnerabilitySummary(String id, String compartmentId, String cveReference, ScanResultProblemSeverity severity, ScanResultVulnerabilityState state, String name, Date timeLastDetected, Date timeFirstDetected, Integer hostCount, VulnerabilityType vulnerabilityType, LifecycleState lifecycleState) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.cveReference = cveReference;
        this.severity = severity;
        this.state = state;
        this.name = name;
        this.timeLastDetected = timeLastDetected;
        this.timeFirstDetected = timeFirstDetected;
        this.hostCount = hostCount;
        this.vulnerabilityType = vulnerabilityType;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getCveReference() {
        return this.cveReference;
    }

    public ScanResultProblemSeverity getSeverity() {
        return this.severity;
    }

    public ScanResultVulnerabilityState getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public Date getTimeLastDetected() {
        return this.timeLastDetected;
    }

    public Date getTimeFirstDetected() {
        return this.timeFirstDetected;
    }

    public Integer getHostCount() {
        return this.hostCount;
    }

    public VulnerabilityType getVulnerabilityType() {
        return this.vulnerabilityType;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostVulnerabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", cveReference=").append(String.valueOf(this.cveReference));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", timeLastDetected=").append(String.valueOf(this.timeLastDetected));
        sb.append(", timeFirstDetected=").append(String.valueOf(this.timeFirstDetected));
        sb.append(", hostCount=").append(String.valueOf(this.hostCount));
        sb.append(", vulnerabilityType=").append(String.valueOf((Object)this.vulnerabilityType));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostVulnerabilitySummary)) {
            return false;
        }
        HostVulnerabilitySummary other = (HostVulnerabilitySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.cveReference, other.cveReference) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.name, other.name) && Objects.equals(this.timeLastDetected, other.timeLastDetected) && Objects.equals(this.timeFirstDetected, other.timeFirstDetected) && Objects.equals(this.hostCount, other.hostCount) && Objects.equals((Object)this.vulnerabilityType, (Object)other.vulnerabilityType) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.cveReference == null ? 43 : this.cveReference.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.timeLastDetected == null ? 43 : this.timeLastDetected.hashCode());
        result = result * 59 + (this.timeFirstDetected == null ? 43 : this.timeFirstDetected.hashCode());
        result = result * 59 + (this.hostCount == null ? 43 : this.hostCount.hashCode());
        result = result * 59 + (this.vulnerabilityType == null ? 43 : this.vulnerabilityType.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="cveReference")
        private String cveReference;
        @JsonProperty(value="severity")
        private ScanResultProblemSeverity severity;
        @JsonProperty(value="state")
        private ScanResultVulnerabilityState state;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="timeLastDetected")
        private Date timeLastDetected;
        @JsonProperty(value="timeFirstDetected")
        private Date timeFirstDetected;
        @JsonProperty(value="hostCount")
        private Integer hostCount;
        @JsonProperty(value="vulnerabilityType")
        private VulnerabilityType vulnerabilityType;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder cveReference(String cveReference) {
            this.cveReference = cveReference;
            this.__explicitlySet__.add("cveReference");
            return this;
        }

        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder state(ScanResultVulnerabilityState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder timeLastDetected(Date timeLastDetected) {
            this.timeLastDetected = timeLastDetected;
            this.__explicitlySet__.add("timeLastDetected");
            return this;
        }

        public Builder timeFirstDetected(Date timeFirstDetected) {
            this.timeFirstDetected = timeFirstDetected;
            this.__explicitlySet__.add("timeFirstDetected");
            return this;
        }

        public Builder hostCount(Integer hostCount) {
            this.hostCount = hostCount;
            this.__explicitlySet__.add("hostCount");
            return this;
        }

        public Builder vulnerabilityType(VulnerabilityType vulnerabilityType) {
            this.vulnerabilityType = vulnerabilityType;
            this.__explicitlySet__.add("vulnerabilityType");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public HostVulnerabilitySummary build() {
            HostVulnerabilitySummary model = new HostVulnerabilitySummary(this.id, this.compartmentId, this.cveReference, this.severity, this.state, this.name, this.timeLastDetected, this.timeFirstDetected, this.hostCount, this.vulnerabilityType, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostVulnerabilitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("cveReference")) {
                this.cveReference(model.getCveReference());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("timeLastDetected")) {
                this.timeLastDetected(model.getTimeLastDetected());
            }
            if (model.wasPropertyExplicitlySet("timeFirstDetected")) {
                this.timeFirstDetected(model.getTimeFirstDetected());
            }
            if (model.wasPropertyExplicitlySet("hostCount")) {
                this.hostCount(model.getHostCount());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilityType")) {
                this.vulnerabilityType(model.getVulnerabilityType());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

