/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.vulnerabilityscanning.model.HostCisBenchmarkSettings;
import com.oracle.bmc.vulnerabilityscanning.model.HostEndpointProtectionSettings;
import com.oracle.bmc.vulnerabilityscanning.model.HostScanAgentConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.VendorType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="vendor")
@JsonFilter(value="explicitlySetFilter")
public final class HostScanAgentConfigurationOCI
extends HostScanAgentConfiguration {
    @JsonProperty(value="cisBenchmarkSettings")
    private final HostCisBenchmarkSettings cisBenchmarkSettings;
    @JsonProperty(value="endpointProtectionSettings")
    private final HostEndpointProtectionSettings endpointProtectionSettings;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HostScanAgentConfigurationOCI(VendorType vendorType, HostCisBenchmarkSettings cisBenchmarkSettings, HostEndpointProtectionSettings endpointProtectionSettings) {
        super(vendorType);
        this.cisBenchmarkSettings = cisBenchmarkSettings;
        this.endpointProtectionSettings = endpointProtectionSettings;
    }

    public HostCisBenchmarkSettings getCisBenchmarkSettings() {
        return this.cisBenchmarkSettings;
    }

    public HostEndpointProtectionSettings getEndpointProtectionSettings() {
        return this.endpointProtectionSettings;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostScanAgentConfigurationOCI(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", cisBenchmarkSettings=").append(String.valueOf((Object)this.cisBenchmarkSettings));
        sb.append(", endpointProtectionSettings=").append(String.valueOf((Object)this.endpointProtectionSettings));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostScanAgentConfigurationOCI)) {
            return false;
        }
        HostScanAgentConfigurationOCI other = (HostScanAgentConfigurationOCI)((Object)o);
        return Objects.equals((Object)this.cisBenchmarkSettings, (Object)other.cisBenchmarkSettings) && Objects.equals((Object)this.endpointProtectionSettings, (Object)other.endpointProtectionSettings) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.cisBenchmarkSettings == null ? 43 : this.cisBenchmarkSettings.hashCode());
        result = result * 59 + (this.endpointProtectionSettings == null ? 43 : this.endpointProtectionSettings.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vendorType")
        private VendorType vendorType;
        @JsonProperty(value="cisBenchmarkSettings")
        private HostCisBenchmarkSettings cisBenchmarkSettings;
        @JsonProperty(value="endpointProtectionSettings")
        private HostEndpointProtectionSettings endpointProtectionSettings;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vendorType(VendorType vendorType) {
            this.vendorType = vendorType;
            this.__explicitlySet__.add("vendorType");
            return this;
        }

        public Builder cisBenchmarkSettings(HostCisBenchmarkSettings cisBenchmarkSettings) {
            this.cisBenchmarkSettings = cisBenchmarkSettings;
            this.__explicitlySet__.add("cisBenchmarkSettings");
            return this;
        }

        public Builder endpointProtectionSettings(HostEndpointProtectionSettings endpointProtectionSettings) {
            this.endpointProtectionSettings = endpointProtectionSettings;
            this.__explicitlySet__.add("endpointProtectionSettings");
            return this;
        }

        public HostScanAgentConfigurationOCI build() {
            HostScanAgentConfigurationOCI model = new HostScanAgentConfigurationOCI(this.vendorType, this.cisBenchmarkSettings, this.endpointProtectionSettings);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostScanAgentConfigurationOCI model) {
            if (model.wasPropertyExplicitlySet("vendorType")) {
                this.vendorType(model.getVendorType());
            }
            if (model.wasPropertyExplicitlySet("cisBenchmarkSettings")) {
                this.cisBenchmarkSettings(model.getCisBenchmarkSettings());
            }
            if (model.wasPropertyExplicitlySet("endpointProtectionSettings")) {
                this.endpointProtectionSettings(model.getEndpointProtectionSettings());
            }
            return this;
        }
    }
}

