/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostPortScanResultOpenPort
extends ExplicitlySetBmcModel {
    @JsonProperty(value="port")
    private final Integer port;
    @JsonProperty(value="protocol")
    private final String protocol;
    @JsonProperty(value="ipAddress")
    private final String ipAddress;
    @JsonProperty(value="vnicId")
    private final String vnicId;
    @JsonProperty(value="service")
    private final String service;
    @JsonProperty(value="severity")
    private final ScanResultProblemSeverity severity;

    @Deprecated
    @ConstructorProperties(value={"port", "protocol", "ipAddress", "vnicId", "service", "severity"})
    public HostPortScanResultOpenPort(Integer port, String protocol, String ipAddress, String vnicId, String service, ScanResultProblemSeverity severity) {
        this.port = port;
        this.protocol = protocol;
        this.ipAddress = ipAddress;
        this.vnicId = vnicId;
        this.service = service;
        this.severity = severity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getVnicId() {
        return this.vnicId;
    }

    public String getService() {
        return this.service;
    }

    public ScanResultProblemSeverity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostPortScanResultOpenPort(");
        sb.append("super=").append(super.toString());
        sb.append("port=").append(String.valueOf(this.port));
        sb.append(", protocol=").append(String.valueOf(this.protocol));
        sb.append(", ipAddress=").append(String.valueOf(this.ipAddress));
        sb.append(", vnicId=").append(String.valueOf(this.vnicId));
        sb.append(", service=").append(String.valueOf(this.service));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostPortScanResultOpenPort)) {
            return false;
        }
        HostPortScanResultOpenPort other = (HostPortScanResultOpenPort)((Object)o);
        return Objects.equals(this.port, other.port) && Objects.equals(this.protocol, other.protocol) && Objects.equals(this.ipAddress, other.ipAddress) && Objects.equals(this.vnicId, other.vnicId) && Objects.equals(this.service, other.service) && Objects.equals((Object)this.severity, (Object)other.severity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + (this.protocol == null ? 43 : this.protocol.hashCode());
        result = result * 59 + (this.ipAddress == null ? 43 : this.ipAddress.hashCode());
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        result = result * 59 + (this.service == null ? 43 : this.service.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="port")
        private Integer port;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="vnicId")
        private String vnicId;
        @JsonProperty(value="service")
        private String service;
        @JsonProperty(value="severity")
        private ScanResultProblemSeverity severity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            this.__explicitlySet__.add("protocol");
            return this;
        }

        public Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            this.__explicitlySet__.add("ipAddress");
            return this;
        }

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            this.__explicitlySet__.add("vnicId");
            return this;
        }

        public Builder service(String service) {
            this.service = service;
            this.__explicitlySet__.add("service");
            return this;
        }

        public Builder severity(ScanResultProblemSeverity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public HostPortScanResultOpenPort build() {
            HostPortScanResultOpenPort model = new HostPortScanResultOpenPort(this.port, this.protocol, this.ipAddress, this.vnicId, this.service, this.severity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostPortScanResultOpenPort model) {
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            if (model.wasPropertyExplicitlySet("protocol")) {
                this.protocol(model.getProtocol());
            }
            if (model.wasPropertyExplicitlySet("ipAddress")) {
                this.ipAddress(model.getIpAddress());
            }
            if (model.wasPropertyExplicitlySet("vnicId")) {
                this.vnicId(model.getVnicId());
            }
            if (model.wasPropertyExplicitlySet("service")) {
                this.service(model.getService());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            return this;
        }
    }
}

