/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.HostPortScanResultOpenPort;
import com.oracle.bmc.vulnerabilityscanning.model.LifecycleState;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class HostPortScanResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="highestProblemSeverity")
    private final ScanResultProblemSeverity highestProblemSeverity;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="openPortCount")
    private final Integer openPortCount;
    @JsonProperty(value="openPorts")
    private final List<HostPortScanResultOpenPort> openPorts;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "instanceId", "compartmentId", "highestProblemSeverity", "timeStarted", "timeFinished", "openPortCount", "openPorts", "lifecycleState"})
    public HostPortScanResult(String id, String displayName, String instanceId, String compartmentId, ScanResultProblemSeverity highestProblemSeverity, Date timeStarted, Date timeFinished, Integer openPortCount, List<HostPortScanResultOpenPort> openPorts, LifecycleState lifecycleState) {
        this.id = id;
        this.displayName = displayName;
        this.instanceId = instanceId;
        this.compartmentId = compartmentId;
        this.highestProblemSeverity = highestProblemSeverity;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.openPortCount = openPortCount;
        this.openPorts = openPorts;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return this.highestProblemSeverity;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Integer getOpenPortCount() {
        return this.openPortCount;
    }

    public List<HostPortScanResultOpenPort> getOpenPorts() {
        return this.openPorts;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HostPortScanResult(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", highestProblemSeverity=").append(String.valueOf((Object)this.highestProblemSeverity));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", openPortCount=").append(String.valueOf(this.openPortCount));
        sb.append(", openPorts=").append(String.valueOf(this.openPorts));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostPortScanResult)) {
            return false;
        }
        HostPortScanResult other = (HostPortScanResult)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.highestProblemSeverity, (Object)other.highestProblemSeverity) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.openPortCount, other.openPortCount) && Objects.equals(this.openPorts, other.openPorts) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.highestProblemSeverity == null ? 43 : this.highestProblemSeverity.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.openPortCount == null ? 43 : this.openPortCount.hashCode());
        result = result * 59 + (this.openPorts == null ? 43 : this.openPorts.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="highestProblemSeverity")
        private ScanResultProblemSeverity highestProblemSeverity;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="openPortCount")
        private Integer openPortCount;
        @JsonProperty(value="openPorts")
        private List<HostPortScanResultOpenPort> openPorts;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            this.__explicitlySet__.add("highestProblemSeverity");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder openPortCount(Integer openPortCount) {
            this.openPortCount = openPortCount;
            this.__explicitlySet__.add("openPortCount");
            return this;
        }

        public Builder openPorts(List<HostPortScanResultOpenPort> openPorts) {
            this.openPorts = openPorts;
            this.__explicitlySet__.add("openPorts");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public HostPortScanResult build() {
            HostPortScanResult model = new HostPortScanResult(this.id, this.displayName, this.instanceId, this.compartmentId, this.highestProblemSeverity, this.timeStarted, this.timeFinished, this.openPortCount, this.openPorts, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HostPortScanResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("highestProblemSeverity")) {
                this.highestProblemSeverity(model.getHighestProblemSeverity());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("openPortCount")) {
                this.openPortCount(model.getOpenPortCount());
            }
            if (model.wasPropertyExplicitlySet("openPorts")) {
                this.openPorts(model.getOpenPorts());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

