/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerScanSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="scanLevel")
    private final ScanLevel scanLevel;

    @Deprecated
    @ConstructorProperties(value={"scanLevel"})
    public ContainerScanSettings(ScanLevel scanLevel) {
        this.scanLevel = scanLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ScanLevel getScanLevel() {
        return this.scanLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerScanSettings(");
        sb.append("super=").append(super.toString());
        sb.append("scanLevel=").append(String.valueOf((Object)this.scanLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerScanSettings)) {
            return false;
        }
        ContainerScanSettings other = (ContainerScanSettings)((Object)o);
        return Objects.equals((Object)this.scanLevel, (Object)other.scanLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.scanLevel == null ? 43 : this.scanLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScanLevel implements BmcEnum
    {
        None("NONE"),
        Standard("STANDARD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScanLevel> map;

        private ScanLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScanLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScanLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScanLevel.class);
            map = new HashMap<String, ScanLevel>();
            for (ScanLevel v : ScanLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="scanLevel")
        private ScanLevel scanLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder scanLevel(ScanLevel scanLevel) {
            this.scanLevel = scanLevel;
            this.__explicitlySet__.add("scanLevel");
            return this;
        }

        public ContainerScanSettings build() {
            ContainerScanSettings model = new ContainerScanSettings(this.scanLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerScanSettings model) {
            if (model.wasPropertyExplicitlySet("scanLevel")) {
                this.scanLevel(model.getScanLevel());
            }
            return this;
        }
    }
}

