/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultProblem;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ContainerScanResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="registryUrl")
    private final String registryUrl;
    @JsonProperty(value="repository")
    private final String repository;
    @JsonProperty(value="image")
    private final String image;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetCompartmentId")
    private final String targetCompartmentId;
    @JsonProperty(value="containerScanTargetId")
    private final String containerScanTargetId;
    @JsonProperty(value="highestProblemSeverity")
    private final ScanResultProblemSeverity highestProblemSeverity;
    @JsonProperty(value="problemCount")
    private final Integer problemCount;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="problems")
    private final List<ContainerScanResultProblem> problems;

    @Deprecated
    @ConstructorProperties(value={"id", "registryUrl", "repository", "image", "compartmentId", "targetCompartmentId", "containerScanTargetId", "highestProblemSeverity", "problemCount", "timeStarted", "timeFinished", "problems"})
    public ContainerScanResult(String id, String registryUrl, String repository, String image, String compartmentId, String targetCompartmentId, String containerScanTargetId, ScanResultProblemSeverity highestProblemSeverity, Integer problemCount, Date timeStarted, Date timeFinished, List<ContainerScanResultProblem> problems) {
        this.id = id;
        this.registryUrl = registryUrl;
        this.repository = repository;
        this.image = image;
        this.compartmentId = compartmentId;
        this.targetCompartmentId = targetCompartmentId;
        this.containerScanTargetId = containerScanTargetId;
        this.highestProblemSeverity = highestProblemSeverity;
        this.problemCount = problemCount;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.problems = problems;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getImage() {
        return this.image;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetCompartmentId() {
        return this.targetCompartmentId;
    }

    public String getContainerScanTargetId() {
        return this.containerScanTargetId;
    }

    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return this.highestProblemSeverity;
    }

    public Integer getProblemCount() {
        return this.problemCount;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public List<ContainerScanResultProblem> getProblems() {
        return this.problems;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ContainerScanResult(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", registryUrl=").append(String.valueOf(this.registryUrl));
        sb.append(", repository=").append(String.valueOf(this.repository));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetCompartmentId=").append(String.valueOf(this.targetCompartmentId));
        sb.append(", containerScanTargetId=").append(String.valueOf(this.containerScanTargetId));
        sb.append(", highestProblemSeverity=").append(String.valueOf((Object)this.highestProblemSeverity));
        sb.append(", problemCount=").append(String.valueOf(this.problemCount));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", problems=").append(String.valueOf(this.problems));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContainerScanResult)) {
            return false;
        }
        ContainerScanResult other = (ContainerScanResult)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.registryUrl, other.registryUrl) && Objects.equals(this.repository, other.repository) && Objects.equals(this.image, other.image) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetCompartmentId, other.targetCompartmentId) && Objects.equals(this.containerScanTargetId, other.containerScanTargetId) && Objects.equals((Object)this.highestProblemSeverity, (Object)other.highestProblemSeverity) && Objects.equals(this.problemCount, other.problemCount) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals(this.problems, other.problems) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.registryUrl == null ? 43 : this.registryUrl.hashCode());
        result = result * 59 + (this.repository == null ? 43 : this.repository.hashCode());
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetCompartmentId == null ? 43 : this.targetCompartmentId.hashCode());
        result = result * 59 + (this.containerScanTargetId == null ? 43 : this.containerScanTargetId.hashCode());
        result = result * 59 + (this.highestProblemSeverity == null ? 43 : this.highestProblemSeverity.hashCode());
        result = result * 59 + (this.problemCount == null ? 43 : this.problemCount.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.problems == null ? 43 : this.problems.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="registryUrl")
        private String registryUrl;
        @JsonProperty(value="repository")
        private String repository;
        @JsonProperty(value="image")
        private String image;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetCompartmentId")
        private String targetCompartmentId;
        @JsonProperty(value="containerScanTargetId")
        private String containerScanTargetId;
        @JsonProperty(value="highestProblemSeverity")
        private ScanResultProblemSeverity highestProblemSeverity;
        @JsonProperty(value="problemCount")
        private Integer problemCount;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="problems")
        private List<ContainerScanResultProblem> problems;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder registryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            this.__explicitlySet__.add("registryUrl");
            return this;
        }

        public Builder repository(String repository) {
            this.repository = repository;
            this.__explicitlySet__.add("repository");
            return this;
        }

        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetCompartmentId(String targetCompartmentId) {
            this.targetCompartmentId = targetCompartmentId;
            this.__explicitlySet__.add("targetCompartmentId");
            return this;
        }

        public Builder containerScanTargetId(String containerScanTargetId) {
            this.containerScanTargetId = containerScanTargetId;
            this.__explicitlySet__.add("containerScanTargetId");
            return this;
        }

        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            this.__explicitlySet__.add("highestProblemSeverity");
            return this;
        }

        public Builder problemCount(Integer problemCount) {
            this.problemCount = problemCount;
            this.__explicitlySet__.add("problemCount");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder problems(List<ContainerScanResultProblem> problems) {
            this.problems = problems;
            this.__explicitlySet__.add("problems");
            return this;
        }

        public ContainerScanResult build() {
            ContainerScanResult model = new ContainerScanResult(this.id, this.registryUrl, this.repository, this.image, this.compartmentId, this.targetCompartmentId, this.containerScanTargetId, this.highestProblemSeverity, this.problemCount, this.timeStarted, this.timeFinished, this.problems);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ContainerScanResult model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("registryUrl")) {
                this.registryUrl(model.getRegistryUrl());
            }
            if (model.wasPropertyExplicitlySet("repository")) {
                this.repository(model.getRepository());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetCompartmentId")) {
                this.targetCompartmentId(model.getTargetCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("containerScanTargetId")) {
                this.containerScanTargetId(model.getContainerScanTargetId());
            }
            if (model.wasPropertyExplicitlySet("highestProblemSeverity")) {
                this.highestProblemSeverity(model.getHighestProblemSeverity());
            }
            if (model.wasPropertyExplicitlySet("problemCount")) {
                this.problemCount(model.getProblemCount());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("problems")) {
                this.problems(model.getProblems());
            }
            return this;
        }
    }
}

