/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.vulnerabilityscanning.model.FolderToScan;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApplicationScanSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="applicationScanRecurrence")
    private final String applicationScanRecurrence;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="foldersToScan")
    private final List<FolderToScan> foldersToScan;

    @Deprecated
    @ConstructorProperties(value={"applicationScanRecurrence", "isEnabled", "foldersToScan"})
    public ApplicationScanSettings(String applicationScanRecurrence, Boolean isEnabled, List<FolderToScan> foldersToScan) {
        this.applicationScanRecurrence = applicationScanRecurrence;
        this.isEnabled = isEnabled;
        this.foldersToScan = foldersToScan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getApplicationScanRecurrence() {
        return this.applicationScanRecurrence;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public List<FolderToScan> getFoldersToScan() {
        return this.foldersToScan;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationScanSettings(");
        sb.append("super=").append(super.toString());
        sb.append("applicationScanRecurrence=").append(String.valueOf(this.applicationScanRecurrence));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", foldersToScan=").append(String.valueOf(this.foldersToScan));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationScanSettings)) {
            return false;
        }
        ApplicationScanSettings other = (ApplicationScanSettings)((Object)o);
        return Objects.equals(this.applicationScanRecurrence, other.applicationScanRecurrence) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.foldersToScan, other.foldersToScan) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.applicationScanRecurrence == null ? 43 : this.applicationScanRecurrence.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.foldersToScan == null ? 43 : this.foldersToScan.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="applicationScanRecurrence")
        private String applicationScanRecurrence;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="foldersToScan")
        private List<FolderToScan> foldersToScan;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder applicationScanRecurrence(String applicationScanRecurrence) {
            this.applicationScanRecurrence = applicationScanRecurrence;
            this.__explicitlySet__.add("applicationScanRecurrence");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder foldersToScan(List<FolderToScan> foldersToScan) {
            this.foldersToScan = foldersToScan;
            this.__explicitlySet__.add("foldersToScan");
            return this;
        }

        public ApplicationScanSettings build() {
            ApplicationScanSettings model = new ApplicationScanSettings(this.applicationScanRecurrence, this.isEnabled, this.foldersToScan);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplicationScanSettings model) {
            if (model.wasPropertyExplicitlySet("applicationScanRecurrence")) {
                this.applicationScanRecurrence(model.getApplicationScanRecurrence());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("foldersToScan")) {
                this.foldersToScan(model.getFoldersToScan());
            }
            return this;
        }
    }
}

