/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.vulnerabilityscanning.VulnerabilityScanning;
import com.oracle.bmc.vulnerabilityscanning.model.LifecycleState;
import com.oracle.bmc.vulnerabilityscanning.requests.GetContainerScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetContainerScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostAgentScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostCisBenchmarkScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostEndpointProtectionScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostPortScanResultRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostScanRecipeRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostScanTargetRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetHostVulnerabilityRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetVulnerabilityRequest;
import com.oracle.bmc.vulnerabilityscanning.requests.GetWorkRequestRequest;
import com.oracle.bmc.vulnerabilityscanning.responses.GetContainerScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetContainerScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostAgentScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostCisBenchmarkScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostEndpointProtectionScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostPortScanResultResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostScanRecipeResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostScanTargetResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetHostVulnerabilityResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetVulnerabilityResponse;
import com.oracle.bmc.vulnerabilityscanning.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class VulnerabilityScanningWaiters {
    private final ExecutorService executorService;
    private final VulnerabilityScanning client;

    public VulnerabilityScanningWaiters(ExecutorService executorService, VulnerabilityScanning client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetContainerScanRecipeRequest, GetContainerScanRecipeResponse> forContainerScanRecipe(GetContainerScanRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerScanRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerScanRecipeRequest, GetContainerScanRecipeResponse> forContainerScanRecipe(GetContainerScanRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerScanRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerScanRecipeRequest, GetContainerScanRecipeResponse> forContainerScanRecipe(GetContainerScanRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerScanRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerScanRecipeRequest, GetContainerScanRecipeResponse> forContainerScanRecipe(BmcGenericWaiter waiter, GetContainerScanRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerScanRecipeRequest, GetContainerScanRecipeResponse>(){

            @Override
            public GetContainerScanRecipeResponse apply(GetContainerScanRecipeRequest request) {
                return VulnerabilityScanningWaiters.this.client.getContainerScanRecipe(request);
            }
        }, (Predicate)new Predicate<GetContainerScanRecipeResponse>(){

            @Override
            public boolean test(GetContainerScanRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getContainerScanRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetContainerScanTargetRequest, GetContainerScanTargetResponse> forContainerScanTarget(GetContainerScanTargetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerScanTarget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetContainerScanTargetRequest, GetContainerScanTargetResponse> forContainerScanTarget(GetContainerScanTargetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forContainerScanTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetContainerScanTargetRequest, GetContainerScanTargetResponse> forContainerScanTarget(GetContainerScanTargetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forContainerScanTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetContainerScanTargetRequest, GetContainerScanTargetResponse> forContainerScanTarget(BmcGenericWaiter waiter, GetContainerScanTargetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetContainerScanTargetRequest, GetContainerScanTargetResponse>(){

            @Override
            public GetContainerScanTargetResponse apply(GetContainerScanTargetRequest request) {
                return VulnerabilityScanningWaiters.this.client.getContainerScanTarget(request);
            }
        }, (Predicate)new Predicate<GetContainerScanTargetResponse>(){

            @Override
            public boolean test(GetContainerScanTargetResponse response) {
                return targetStatesSet.contains((Object)response.getContainerScanTarget().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostAgentScanResultRequest, GetHostAgentScanResultResponse> forHostAgentScanResult(GetHostAgentScanResultRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostAgentScanResult(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostAgentScanResultRequest, GetHostAgentScanResultResponse> forHostAgentScanResult(GetHostAgentScanResultRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostAgentScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostAgentScanResultRequest, GetHostAgentScanResultResponse> forHostAgentScanResult(GetHostAgentScanResultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostAgentScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostAgentScanResultRequest, GetHostAgentScanResultResponse> forHostAgentScanResult(BmcGenericWaiter waiter, GetHostAgentScanResultRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostAgentScanResultRequest, GetHostAgentScanResultResponse>(){

            @Override
            public GetHostAgentScanResultResponse apply(GetHostAgentScanResultRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostAgentScanResult(request);
            }
        }, (Predicate)new Predicate<GetHostAgentScanResultResponse>(){

            @Override
            public boolean test(GetHostAgentScanResultResponse response) {
                return targetStatesSet.contains((Object)response.getHostAgentScanResult().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse> forHostCisBenchmarkScanResult(GetHostCisBenchmarkScanResultRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostCisBenchmarkScanResult(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse> forHostCisBenchmarkScanResult(GetHostCisBenchmarkScanResultRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostCisBenchmarkScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse> forHostCisBenchmarkScanResult(GetHostCisBenchmarkScanResultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostCisBenchmarkScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse> forHostCisBenchmarkScanResult(BmcGenericWaiter waiter, GetHostCisBenchmarkScanResultRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostCisBenchmarkScanResultRequest, GetHostCisBenchmarkScanResultResponse>(){

            @Override
            public GetHostCisBenchmarkScanResultResponse apply(GetHostCisBenchmarkScanResultRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostCisBenchmarkScanResult(request);
            }
        }, (Predicate)new Predicate<GetHostCisBenchmarkScanResultResponse>(){

            @Override
            public boolean test(GetHostCisBenchmarkScanResultResponse response) {
                return targetStatesSet.contains((Object)response.getHostCisBenchmarkScanResult().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostEndpointProtectionScanResultRequest, GetHostEndpointProtectionScanResultResponse> forHostEndpointProtectionScanResult(GetHostEndpointProtectionScanResultRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostEndpointProtectionScanResult(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostEndpointProtectionScanResultRequest, GetHostEndpointProtectionScanResultResponse> forHostEndpointProtectionScanResult(GetHostEndpointProtectionScanResultRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostEndpointProtectionScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostEndpointProtectionScanResultRequest, GetHostEndpointProtectionScanResultResponse> forHostEndpointProtectionScanResult(GetHostEndpointProtectionScanResultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostEndpointProtectionScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostEndpointProtectionScanResultRequest, GetHostEndpointProtectionScanResultResponse> forHostEndpointProtectionScanResult(BmcGenericWaiter waiter, GetHostEndpointProtectionScanResultRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostEndpointProtectionScanResultRequest, GetHostEndpointProtectionScanResultResponse>(){

            @Override
            public GetHostEndpointProtectionScanResultResponse apply(GetHostEndpointProtectionScanResultRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostEndpointProtectionScanResult(request);
            }
        }, (Predicate)new Predicate<GetHostEndpointProtectionScanResultResponse>(){

            @Override
            public boolean test(GetHostEndpointProtectionScanResultResponse response) {
                return targetStatesSet.contains((Object)response.getHostEndpointProtectionScanResult().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse> forHostPortScanResult(GetHostPortScanResultRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostPortScanResult(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse> forHostPortScanResult(GetHostPortScanResultRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostPortScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse> forHostPortScanResult(GetHostPortScanResultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostPortScanResult(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostPortScanResultRequest, GetHostPortScanResultResponse> forHostPortScanResult(BmcGenericWaiter waiter, GetHostPortScanResultRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostPortScanResultRequest, GetHostPortScanResultResponse>(){

            @Override
            public GetHostPortScanResultResponse apply(GetHostPortScanResultRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostPortScanResult(request);
            }
        }, (Predicate)new Predicate<GetHostPortScanResultResponse>(){

            @Override
            public boolean test(GetHostPortScanResultResponse response) {
                return targetStatesSet.contains((Object)response.getHostPortScanResult().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse> forHostScanRecipe(GetHostScanRecipeRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostScanRecipe(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse> forHostScanRecipe(GetHostScanRecipeRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostScanRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse> forHostScanRecipe(GetHostScanRecipeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostScanRecipe(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostScanRecipeRequest, GetHostScanRecipeResponse> forHostScanRecipe(BmcGenericWaiter waiter, GetHostScanRecipeRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostScanRecipeRequest, GetHostScanRecipeResponse>(){

            @Override
            public GetHostScanRecipeResponse apply(GetHostScanRecipeRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostScanRecipe(request);
            }
        }, (Predicate)new Predicate<GetHostScanRecipeResponse>(){

            @Override
            public boolean test(GetHostScanRecipeResponse response) {
                return targetStatesSet.contains((Object)response.getHostScanRecipe().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse> forHostScanTarget(GetHostScanTargetRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostScanTarget(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse> forHostScanTarget(GetHostScanTargetRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostScanTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse> forHostScanTarget(GetHostScanTargetRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostScanTarget(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostScanTargetRequest, GetHostScanTargetResponse> forHostScanTarget(BmcGenericWaiter waiter, GetHostScanTargetRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostScanTargetRequest, GetHostScanTargetResponse>(){

            @Override
            public GetHostScanTargetResponse apply(GetHostScanTargetRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostScanTarget(request);
            }
        }, (Predicate)new Predicate<GetHostScanTargetResponse>(){

            @Override
            public boolean test(GetHostScanTargetResponse response) {
                return targetStatesSet.contains((Object)response.getHostScanTarget().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse> forHostVulnerability(GetHostVulnerabilityRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostVulnerability(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse> forHostVulnerability(GetHostVulnerabilityRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forHostVulnerability(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse> forHostVulnerability(GetHostVulnerabilityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forHostVulnerability(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse> forHostVulnerability(BmcGenericWaiter waiter, GetHostVulnerabilityRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetHostVulnerabilityRequest, GetHostVulnerabilityResponse>(){

            @Override
            public GetHostVulnerabilityResponse apply(GetHostVulnerabilityRequest request) {
                return VulnerabilityScanningWaiters.this.client.getHostVulnerability(request);
            }
        }, (Predicate)new Predicate<GetHostVulnerabilityResponse>(){

            @Override
            public boolean test(GetHostVulnerabilityResponse response) {
                return targetStatesSet.contains((Object)response.getHostVulnerability().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse> forVulnerability(GetVulnerabilityRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVulnerability(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse> forVulnerability(GetVulnerabilityRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVulnerability(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse> forVulnerability(GetVulnerabilityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVulnerability(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVulnerabilityRequest, GetVulnerabilityResponse> forVulnerability(BmcGenericWaiter waiter, GetVulnerabilityRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVulnerabilityRequest, GetVulnerabilityResponse>(){

            @Override
            public GetVulnerabilityResponse apply(GetVulnerabilityRequest request) {
                return VulnerabilityScanningWaiters.this.client.getVulnerability(request);
            }
        }, (Predicate)new Predicate<GetVulnerabilityResponse>(){

            @Override
            public boolean test(GetVulnerabilityResponse response) {
                return targetStatesSet.contains((Object)response.getVulnerability().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return VulnerabilityScanningWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

