/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.visualbuilder.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AttachmentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetRole")
    private final TargetRole targetRole;
    @JsonProperty(value="isImplicit")
    private final Boolean isImplicit;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetInstanceUrl")
    private final String targetInstanceUrl;
    @JsonProperty(value="targetServiceType")
    private final String targetServiceType;

    @Deprecated
    @ConstructorProperties(value={"targetRole", "isImplicit", "targetId", "targetInstanceUrl", "targetServiceType"})
    public AttachmentDetails(TargetRole targetRole, Boolean isImplicit, String targetId, String targetInstanceUrl, String targetServiceType) {
        this.targetRole = targetRole;
        this.isImplicit = isImplicit;
        this.targetId = targetId;
        this.targetInstanceUrl = targetInstanceUrl;
        this.targetServiceType = targetServiceType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public TargetRole getTargetRole() {
        return this.targetRole;
    }

    public Boolean getIsImplicit() {
        return this.isImplicit;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetInstanceUrl() {
        return this.targetInstanceUrl;
    }

    public String getTargetServiceType() {
        return this.targetServiceType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AttachmentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("targetRole=").append(String.valueOf((Object)this.targetRole));
        sb.append(", isImplicit=").append(String.valueOf(this.isImplicit));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetInstanceUrl=").append(String.valueOf(this.targetInstanceUrl));
        sb.append(", targetServiceType=").append(String.valueOf(this.targetServiceType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttachmentDetails)) {
            return false;
        }
        AttachmentDetails other = (AttachmentDetails)((Object)o);
        return Objects.equals((Object)this.targetRole, (Object)other.targetRole) && Objects.equals(this.isImplicit, other.isImplicit) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetInstanceUrl, other.targetInstanceUrl) && Objects.equals(this.targetServiceType, other.targetServiceType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetRole == null ? 43 : this.targetRole.hashCode());
        result = result * 59 + (this.isImplicit == null ? 43 : this.isImplicit.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetInstanceUrl == null ? 43 : this.targetInstanceUrl.hashCode());
        result = result * 59 + (this.targetServiceType == null ? 43 : this.targetServiceType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TargetRole implements BmcEnum
    {
        Parent("PARENT"),
        Child("CHILD"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TargetRole> map;

        private TargetRole(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetRole create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TargetRole', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TargetRole.class);
            map = new HashMap<String, TargetRole>();
            for (TargetRole v : TargetRole.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetRole")
        private TargetRole targetRole;
        @JsonProperty(value="isImplicit")
        private Boolean isImplicit;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetInstanceUrl")
        private String targetInstanceUrl;
        @JsonProperty(value="targetServiceType")
        private String targetServiceType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetRole(TargetRole targetRole) {
            this.targetRole = targetRole;
            this.__explicitlySet__.add("targetRole");
            return this;
        }

        public Builder isImplicit(Boolean isImplicit) {
            this.isImplicit = isImplicit;
            this.__explicitlySet__.add("isImplicit");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetInstanceUrl(String targetInstanceUrl) {
            this.targetInstanceUrl = targetInstanceUrl;
            this.__explicitlySet__.add("targetInstanceUrl");
            return this;
        }

        public Builder targetServiceType(String targetServiceType) {
            this.targetServiceType = targetServiceType;
            this.__explicitlySet__.add("targetServiceType");
            return this;
        }

        public AttachmentDetails build() {
            AttachmentDetails model = new AttachmentDetails(this.targetRole, this.isImplicit, this.targetId, this.targetInstanceUrl, this.targetServiceType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AttachmentDetails model) {
            if (model.wasPropertyExplicitlySet("targetRole")) {
                this.targetRole(model.getTargetRole());
            }
            if (model.wasPropertyExplicitlySet("isImplicit")) {
                this.isImplicit(model.getIsImplicit());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetInstanceUrl")) {
                this.targetInstanceUrl(model.getTargetInstanceUrl());
            }
            if (model.wasPropertyExplicitlySet("targetServiceType")) {
                this.targetServiceType(model.getTargetServiceType());
            }
            return this;
        }
    }
}

