/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.threatintelligence.model.SummarizeIndicatorsDetails;
import java.util.Objects;

public class SummarizeIndicatorsRequest
extends BmcRequest<SummarizeIndicatorsDetails> {
    private String compartmentId;
    private SummarizeIndicatorsDetails summarizeIndicatorsDetails;
    private String opcRequestId;
    private Integer limit;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public SummarizeIndicatorsDetails getSummarizeIndicatorsDetails() {
        return this.summarizeIndicatorsDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    @InternalSdk
    public SummarizeIndicatorsDetails getBody$() {
        return this.summarizeIndicatorsDetails;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).summarizeIndicatorsDetails(this.summarizeIndicatorsDetails).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",summarizeIndicatorsDetails=").append(String.valueOf((Object)this.summarizeIndicatorsDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SummarizeIndicatorsRequest)) {
            return false;
        }
        SummarizeIndicatorsRequest other = (SummarizeIndicatorsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.summarizeIndicatorsDetails, (Object)other.summarizeIndicatorsDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.summarizeIndicatorsDetails == null ? 43 : this.summarizeIndicatorsDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SummarizeIndicatorsRequest, SummarizeIndicatorsDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private SummarizeIndicatorsDetails summarizeIndicatorsDetails = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder summarizeIndicatorsDetails(SummarizeIndicatorsDetails summarizeIndicatorsDetails) {
            this.summarizeIndicatorsDetails = summarizeIndicatorsDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SummarizeIndicatorsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.summarizeIndicatorsDetails(o.getSummarizeIndicatorsDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SummarizeIndicatorsRequest build() {
            SummarizeIndicatorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SummarizeIndicatorsDetails body) {
            this.summarizeIndicatorsDetails(body);
            return this;
        }

        public SummarizeIndicatorsRequest buildWithoutInvocationCallback() {
            SummarizeIndicatorsRequest request = new SummarizeIndicatorsRequest();
            request.compartmentId = this.compartmentId;
            request.summarizeIndicatorsDetails = this.summarizeIndicatorsDetails;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            return request;
        }
    }
}

