/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.threatintelligence.model.SortOrder;
import java.util.Objects;

public class ListIndicatorCountsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private SortOrder sortOrder;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIndicatorCountsRequest)) {
            return false;
        }
        ListIndicatorCountsRequest other = (ListIndicatorCountsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIndicatorCountsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private SortOrder sortOrder = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIndicatorCountsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIndicatorCountsRequest build() {
            ListIndicatorCountsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIndicatorCountsRequest buildWithoutInvocationCallback() {
            ListIndicatorCountsRequest request = new ListIndicatorCountsRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }
}

