/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.threatintelligence.model.DataAttribution;
import com.oracle.bmc.threatintelligence.model.EntityReference;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IndicatorRelationship
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="relatedEntity")
    private final EntityReference relatedEntity;
    @JsonProperty(value="attribution")
    private final List<DataAttribution> attribution;

    @Deprecated
    @ConstructorProperties(value={"name", "relatedEntity", "attribution"})
    public IndicatorRelationship(String name, EntityReference relatedEntity, List<DataAttribution> attribution) {
        this.name = name;
        this.relatedEntity = relatedEntity;
        this.attribution = attribution;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public EntityReference getRelatedEntity() {
        return this.relatedEntity;
    }

    public List<DataAttribution> getAttribution() {
        return this.attribution;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IndicatorRelationship(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", relatedEntity=").append(String.valueOf((Object)this.relatedEntity));
        sb.append(", attribution=").append(String.valueOf(this.attribution));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndicatorRelationship)) {
            return false;
        }
        IndicatorRelationship other = (IndicatorRelationship)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.relatedEntity, (Object)other.relatedEntity) && Objects.equals(this.attribution, other.attribution) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.relatedEntity == null ? 43 : this.relatedEntity.hashCode());
        result = result * 59 + (this.attribution == null ? 43 : this.attribution.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="relatedEntity")
        private EntityReference relatedEntity;
        @JsonProperty(value="attribution")
        private List<DataAttribution> attribution;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder relatedEntity(EntityReference relatedEntity) {
            this.relatedEntity = relatedEntity;
            this.__explicitlySet__.add("relatedEntity");
            return this;
        }

        public Builder attribution(List<DataAttribution> attribution) {
            this.attribution = attribution;
            this.__explicitlySet__.add("attribution");
            return this;
        }

        public IndicatorRelationship build() {
            IndicatorRelationship model = new IndicatorRelationship(this.name, this.relatedEntity, this.attribution);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IndicatorRelationship model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("relatedEntity")) {
                this.relatedEntity(model.getRelatedEntity());
            }
            if (model.wasPropertyExplicitlySet("attribution")) {
                this.attribution(model.getAttribution());
            }
            return this;
        }
    }
}

