/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.threatintelligence;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.threatintelligence.Threatintel;
import com.oracle.bmc.threatintelligence.ThreatintelAsyncClient;
import com.oracle.bmc.threatintelligence.ThreatintelPaginators;
import com.oracle.bmc.threatintelligence.ThreatintelWaiters;
import com.oracle.bmc.threatintelligence.model.Indicator;
import com.oracle.bmc.threatintelligence.model.IndicatorCountCollection;
import com.oracle.bmc.threatintelligence.model.IndicatorSummaryCollection;
import com.oracle.bmc.threatintelligence.model.ThreatTypesCollection;
import com.oracle.bmc.threatintelligence.requests.GetIndicatorRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorCountsRequest;
import com.oracle.bmc.threatintelligence.requests.ListIndicatorsRequest;
import com.oracle.bmc.threatintelligence.requests.ListThreatTypesRequest;
import com.oracle.bmc.threatintelligence.requests.SummarizeIndicatorsRequest;
import com.oracle.bmc.threatintelligence.responses.GetIndicatorResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorCountsResponse;
import com.oracle.bmc.threatintelligence.responses.ListIndicatorsResponse;
import com.oracle.bmc.threatintelligence.responses.ListThreatTypesResponse;
import com.oracle.bmc.threatintelligence.responses.SummarizeIndicatorsResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreatintelClient
extends BaseSyncClient
implements Threatintel {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("THREATINTEL").serviceEndpointPrefix("").serviceEndpointTemplate("https://api-threatintel.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ThreatintelAsyncClient.class);
    private final ThreatintelWaiters waiters;
    private final ThreatintelPaginators paginators;

    private ThreatintelClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Threatintel-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ThreatintelWaiters(executorService, this);
        this.paginators = new ThreatintelPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public GetIndicatorResponse getIndicator(GetIndicatorRequest request) {
        Validate.notBlank((String)request.getIndicatorId(), (String)"indicatorId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetIndicatorResponse)this.clientCall(request, GetIndicatorResponse::builder).logger(LOG, "getIndicator").serviceDetails("Threatintel", "GetIndicator", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/Indicator/GetIndicator").method(Method.GET).requestBuilder(GetIndicatorRequest::builder).basePath("/20220901").appendPathParam("indicators").appendPathParam(request.getIndicatorId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Indicator.class, GetIndicatorResponse.Builder::indicator).handleResponseHeaderString("opc-request-id", GetIndicatorResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListIndicatorCountsResponse listIndicatorCounts(ListIndicatorCountsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIndicatorCountsResponse)this.clientCall(request, ListIndicatorCountsResponse::builder).logger(LOG, "listIndicatorCounts").serviceDetails("Threatintel", "ListIndicatorCounts", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/IndicatorCountCollection/ListIndicatorCounts").method(Method.GET).requestBuilder(ListIndicatorCountsRequest::builder).basePath("/20220901").appendPathParam("indicatorCounts").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IndicatorCountCollection.class, ListIndicatorCountsResponse.Builder::indicatorCountCollection).handleResponseHeaderString("opc-request-id", ListIndicatorCountsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListIndicatorsResponse listIndicators(ListIndicatorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIndicatorsResponse)this.clientCall(request, ListIndicatorsResponse::builder).logger(LOG, "listIndicators").serviceDetails("Threatintel", "ListIndicators", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/IndicatorSummaryCollection/ListIndicators").method(Method.GET).requestBuilder(ListIndicatorsRequest::builder).basePath("/20220901").appendPathParam("indicators").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("threatTypeName", request.getThreatTypeName(), CollectionFormatType.Multi).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendQueryParam("value", (Object)request.getValue()).appendQueryParam("confidenceGreaterThanOrEqualTo", (Object)request.getConfidenceGreaterThanOrEqualTo()).appendQueryParam("timeUpdatedGreaterThanOrEqualTo", (Object)request.getTimeUpdatedGreaterThanOrEqualTo()).appendQueryParam("timeUpdatedLessThan", (Object)request.getTimeUpdatedLessThan()).appendQueryParam("timeLastSeenGreaterThanOrEqualTo", (Object)request.getTimeLastSeenGreaterThanOrEqualTo()).appendQueryParam("timeLastSeenLessThan", (Object)request.getTimeLastSeenLessThan()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IndicatorSummaryCollection.class, ListIndicatorsResponse.Builder::indicatorSummaryCollection).handleResponseHeaderString("opc-request-id", ListIndicatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIndicatorsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListThreatTypesResponse listThreatTypes(ListThreatTypesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListThreatTypesResponse)this.clientCall(request, ListThreatTypesResponse::builder).logger(LOG, "listThreatTypes").serviceDetails("Threatintel", "ListThreatTypes", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/ThreatTypesCollection/ListThreatTypes").method(Method.GET).requestBuilder(ListThreatTypesRequest::builder).basePath("/20220901").appendPathParam("threatTypes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ThreatTypesCollection.class, ListThreatTypesResponse.Builder::threatTypesCollection).handleResponseHeaderString("opc-request-id", ListThreatTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListThreatTypesResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public SummarizeIndicatorsResponse summarizeIndicators(SummarizeIndicatorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getSummarizeIndicatorsDetails(), "summarizeIndicatorsDetails is required");
        return (SummarizeIndicatorsResponse)this.clientCall(request, SummarizeIndicatorsResponse::builder).logger(LOG, "summarizeIndicators").serviceDetails("Threatintel", "SummarizeIndicators", "https://docs.oracle.com/iaas/api/#/en/threat-intel/20220901/Indicator/SummarizeIndicators").method(Method.POST).requestBuilder(SummarizeIndicatorsRequest::builder).basePath("/20220901").appendPathParam("indicators").appendPathParam("actions").appendPathParam("summarize").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(IndicatorSummaryCollection.class, SummarizeIndicatorsResponse.Builder::indicatorSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeIndicatorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeIndicatorsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ThreatintelWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ThreatintelPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ThreatintelClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ThreatintelClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ThreatintelClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ThreatintelClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ThreatintelClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ThreatintelClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ThreatintelClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ThreatintelClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

