/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitationStatus;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListSenderInvitationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String recipientTenancyId;
    private LifecycleState lifecycleState;
    private SenderInvitationStatus status;
    private String displayName;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRecipientTenancyId() {
        return this.recipientTenancyId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SenderInvitationStatus getStatus() {
        return this.status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).recipientTenancyId(this.recipientTenancyId).lifecycleState(this.lifecycleState).status(this.status).displayName(this.displayName).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",recipientTenancyId=").append(String.valueOf(this.recipientTenancyId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSenderInvitationsRequest)) {
            return false;
        }
        ListSenderInvitationsRequest other = (ListSenderInvitationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.recipientTenancyId, other.recipientTenancyId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.recipientTenancyId == null ? 43 : this.recipientTenancyId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSenderInvitationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String recipientTenancyId = null;
        private LifecycleState lifecycleState = null;
        private SenderInvitationStatus status = null;
        private String displayName = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder recipientTenancyId(String recipientTenancyId) {
            this.recipientTenancyId = recipientTenancyId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder status(SenderInvitationStatus status) {
            this.status = status;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSenderInvitationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.recipientTenancyId(o.getRecipientTenancyId());
            this.lifecycleState(o.getLifecycleState());
            this.status(o.getStatus());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSenderInvitationsRequest build() {
            ListSenderInvitationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSenderInvitationsRequest buildWithoutInvocationCallback() {
            ListSenderInvitationsRequest request = new ListSenderInvitationsRequest();
            request.compartmentId = this.compartmentId;
            request.recipientTenancyId = this.recipientTenancyId;
            request.lifecycleState = this.lifecycleState;
            request.status = this.status;
            request.displayName = this.displayName;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

