/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationStatus;
import java.util.Objects;

public class ListRecipientInvitationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String senderTenancyId;
    private LifecycleState lifecycleState;
    private RecipientInvitationStatus status;
    private String opcRequestId;
    private String page;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSenderTenancyId() {
        return this.senderTenancyId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public RecipientInvitationStatus getStatus() {
        return this.status;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).senderTenancyId(this.senderTenancyId).lifecycleState(this.lifecycleState).status(this.status).opcRequestId(this.opcRequestId).page(this.page);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",senderTenancyId=").append(String.valueOf(this.senderTenancyId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",status=").append(String.valueOf((Object)this.status));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRecipientInvitationsRequest)) {
            return false;
        }
        ListRecipientInvitationsRequest other = (ListRecipientInvitationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.senderTenancyId, other.senderTenancyId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.senderTenancyId == null ? 43 : this.senderTenancyId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecipientInvitationsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String senderTenancyId = null;
        private LifecycleState lifecycleState = null;
        private RecipientInvitationStatus status = null;
        private String opcRequestId = null;
        private String page = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder senderTenancyId(String senderTenancyId) {
            this.senderTenancyId = senderTenancyId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder status(RecipientInvitationStatus status) {
            this.status = status;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecipientInvitationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.senderTenancyId(o.getSenderTenancyId());
            this.lifecycleState(o.getLifecycleState());
            this.status(o.getStatus());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecipientInvitationsRequest build() {
            ListRecipientInvitationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRecipientInvitationsRequest buildWithoutInvocationCallback() {
            ListRecipientInvitationsRequest request = new ListRecipientInvitationsRequest();
            request.compartmentId = this.compartmentId;
            request.senderTenancyId = this.senderTenancyId;
            request.lifecycleState = this.lifecycleState;
            request.status = this.status;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            return request;
        }
    }
}

