/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDomainGovernanceRequest
extends BmcRequest<Void> {
    private String domainGovernanceId;
    private String opcRequestId;

    public String getDomainGovernanceId() {
        return this.domainGovernanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().domainGovernanceId(this.domainGovernanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",domainGovernanceId=").append(String.valueOf(this.domainGovernanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDomainGovernanceRequest)) {
            return false;
        }
        GetDomainGovernanceRequest other = (GetDomainGovernanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.domainGovernanceId, other.domainGovernanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.domainGovernanceId == null ? 43 : this.domainGovernanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDomainGovernanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String domainGovernanceId = null;
        private String opcRequestId = null;

        public Builder domainGovernanceId(String domainGovernanceId) {
            this.domainGovernanceId = domainGovernanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDomainGovernanceRequest o) {
            this.domainGovernanceId(o.getDomainGovernanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDomainGovernanceRequest build() {
            GetDomainGovernanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDomainGovernanceRequest buildWithoutInvocationCallback() {
            GetDomainGovernanceRequest request = new GetDomainGovernanceRequest();
            request.domainGovernanceId = this.domainGovernanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

