/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAssignedSubscriptionRequest
extends BmcRequest<Void> {
    private String assignedSubscriptionId;
    private String opcRequestId;

    public String getAssignedSubscriptionId() {
        return this.assignedSubscriptionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().assignedSubscriptionId(this.assignedSubscriptionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",assignedSubscriptionId=").append(String.valueOf(this.assignedSubscriptionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAssignedSubscriptionRequest)) {
            return false;
        }
        GetAssignedSubscriptionRequest other = (GetAssignedSubscriptionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.assignedSubscriptionId, other.assignedSubscriptionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.assignedSubscriptionId == null ? 43 : this.assignedSubscriptionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAssignedSubscriptionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String assignedSubscriptionId = null;
        private String opcRequestId = null;

        public Builder assignedSubscriptionId(String assignedSubscriptionId) {
            this.assignedSubscriptionId = assignedSubscriptionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAssignedSubscriptionRequest o) {
            this.assignedSubscriptionId(o.getAssignedSubscriptionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAssignedSubscriptionRequest build() {
            GetAssignedSubscriptionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAssignedSubscriptionRequest buildWithoutInvocationCallback() {
            GetAssignedSubscriptionRequest request = new GetAssignedSubscriptionRequest();
            request.assignedSubscriptionId = this.assignedSubscriptionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

