/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.SubscriptionAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.AssignedSubscriptionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.AvailableRegionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.Subscription;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMapping;
import com.oracle.bmc.tenantmanagercontrolplane.model.SubscriptionMappingCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetAssignedSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionMappingRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetSubscriptionRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAssignedSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListAvailableRegionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionMappingsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListSubscriptionsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetAssignedSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionMappingResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetSubscriptionResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAssignedSubscriptionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListAvailableRegionsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionMappingsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListSubscriptionsResponse;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionAsyncClient
extends BaseAsyncClient
implements SubscriptionAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("SUBSCRIPTION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionAsyncClient.class);

    private SubscriptionAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateSubscriptionMappingResponse> createSubscriptionMapping(CreateSubscriptionMappingRequest request, AsyncHandler<CreateSubscriptionMappingRequest, CreateSubscriptionMappingResponse> handler) {
        Objects.requireNonNull(request.getCreateSubscriptionMappingDetails(), "createSubscriptionMappingDetails is required");
        return this.clientCall(request, CreateSubscriptionMappingResponse::builder).logger(LOG, "createSubscriptionMapping").serviceDetails("Subscription", "CreateSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/SubscriptionMapping/CreateSubscriptionMapping").method(Method.POST).requestBuilder(CreateSubscriptionMappingRequest::builder).basePath("/20200801").appendPathParam("subscriptionMappings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(SubscriptionMapping.class, CreateSubscriptionMappingResponse.Builder::subscriptionMapping).handleResponseHeaderString("opc-request-id", CreateSubscriptionMappingResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateSubscriptionMappingResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateSubscriptionMappingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteSubscriptionMappingResponse> deleteSubscriptionMapping(DeleteSubscriptionMappingRequest request, AsyncHandler<DeleteSubscriptionMappingRequest, DeleteSubscriptionMappingResponse> handler) {
        Validate.notBlank((String)request.getSubscriptionMappingId(), (String)"subscriptionMappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteSubscriptionMappingResponse::builder).logger(LOG, "deleteSubscriptionMapping").serviceDetails("Subscription", "DeleteSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/SubscriptionMapping/DeleteSubscriptionMapping").method(Method.DELETE).requestBuilder(DeleteSubscriptionMappingRequest::builder).basePath("/20200801").appendPathParam("subscriptionMappings").appendPathParam(request.getSubscriptionMappingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteSubscriptionMappingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAssignedSubscriptionResponse> getAssignedSubscription(GetAssignedSubscriptionRequest request, AsyncHandler<GetAssignedSubscriptionRequest, GetAssignedSubscriptionResponse> handler) {
        Validate.notBlank((String)request.getAssignedSubscriptionId(), (String)"assignedSubscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAssignedSubscriptionResponse::builder).logger(LOG, "getAssignedSubscription").serviceDetails("Subscription", "GetAssignedSubscription", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/AssignedSubscription/GetAssignedSubscription").method(Method.GET).requestBuilder(GetAssignedSubscriptionRequest::builder).basePath("/20200801").appendPathParam("assignedSubscriptions").appendPathParam(request.getAssignedSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssignedSubscription.class, GetAssignedSubscriptionResponse.Builder::assignedSubscription).handleResponseHeaderString("opc-request-id", GetAssignedSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetAssignedSubscriptionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetSubscriptionResponse> getSubscription(GetSubscriptionRequest request, AsyncHandler<GetSubscriptionRequest, GetSubscriptionResponse> handler) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSubscriptionResponse::builder).logger(LOG, "getSubscription").serviceDetails("Subscription", "GetSubscription", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Subscription/GetSubscription").method(Method.GET).requestBuilder(GetSubscriptionRequest::builder).basePath("/20200801").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Subscription.class, GetSubscriptionResponse.Builder::subscription).handleResponseHeaderString("opc-request-id", GetSubscriptionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSubscriptionResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetSubscriptionMappingResponse> getSubscriptionMapping(GetSubscriptionMappingRequest request, AsyncHandler<GetSubscriptionMappingRequest, GetSubscriptionMappingResponse> handler) {
        Validate.notBlank((String)request.getSubscriptionMappingId(), (String)"subscriptionMappingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetSubscriptionMappingResponse::builder).logger(LOG, "getSubscriptionMapping").serviceDetails("Subscription", "GetSubscriptionMapping", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/SubscriptionMapping/GetSubscriptionMapping").method(Method.GET).requestBuilder(GetSubscriptionMappingRequest::builder).basePath("/20200801").appendPathParam("subscriptionMappings").appendPathParam(request.getSubscriptionMappingId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionMapping.class, GetSubscriptionMappingResponse.Builder::subscriptionMapping).handleResponseHeaderString("opc-request-id", GetSubscriptionMappingResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetSubscriptionMappingResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<ListAssignedSubscriptionsResponse> listAssignedSubscriptions(ListAssignedSubscriptionsRequest request, AsyncHandler<ListAssignedSubscriptionsRequest, ListAssignedSubscriptionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAssignedSubscriptionsResponse::builder).logger(LOG, "listAssignedSubscriptions").serviceDetails("Subscription", "ListAssignedSubscriptions", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/AssignedSubscription/ListAssignedSubscriptions").method(Method.GET).requestBuilder(ListAssignedSubscriptionsRequest::builder).basePath("/20200801").appendPathParam("assignedSubscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssignedSubscriptionCollection.class, ListAssignedSubscriptionsResponse.Builder::assignedSubscriptionCollection).handleResponseHeaderString("opc-next-page", ListAssignedSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAssignedSubscriptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAvailableRegionsResponse> listAvailableRegions(ListAvailableRegionsRequest request, AsyncHandler<ListAvailableRegionsRequest, ListAvailableRegionsResponse> handler) {
        Validate.notBlank((String)request.getSubscriptionId(), (String)"subscriptionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAvailableRegionsResponse::builder).logger(LOG, "listAvailableRegions").serviceDetails("Subscription", "ListAvailableRegions", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Subscription/ListAvailableRegions").method(Method.GET).requestBuilder(ListAvailableRegionsRequest::builder).basePath("/20200801").appendPathParam("subscriptions").appendPathParam(request.getSubscriptionId()).appendPathParam("availableRegions").appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AvailableRegionCollection.class, ListAvailableRegionsResponse.Builder::availableRegionCollection).handleResponseHeaderString("opc-next-page", ListAvailableRegionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAvailableRegionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSubscriptionMappingsResponse> listSubscriptionMappings(ListSubscriptionMappingsRequest request, AsyncHandler<ListSubscriptionMappingsRequest, ListSubscriptionMappingsResponse> handler) {
        Objects.requireNonNull(request.getSubscriptionId(), "subscriptionId is required");
        return this.clientCall(request, ListSubscriptionMappingsResponse::builder).logger(LOG, "listSubscriptionMappings").serviceDetails("Subscription", "ListSubscriptionMappings", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/SubscriptionMapping/ListSubscriptionMappings").method(Method.GET).requestBuilder(ListSubscriptionMappingsRequest::builder).basePath("/20200801").appendPathParam("subscriptionMappings").appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("subscriptionMappingId", (Object)request.getSubscriptionMappingId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionMappingCollection.class, ListSubscriptionMappingsResponse.Builder::subscriptionMappingCollection).handleResponseHeaderString("opc-next-page", ListSubscriptionMappingsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubscriptionMappingsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest request, AsyncHandler<ListSubscriptionsRequest, ListSubscriptionsResponse> handler) {
        return this.clientCall(request, ListSubscriptionsResponse::builder).logger(LOG, "listSubscriptions").serviceDetails("Subscription", "ListSubscriptions", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Subscription/ListSubscriptions").method(Method.GET).requestBuilder(ListSubscriptionsRequest::builder).basePath("/20200801").appendPathParam("subscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("subscriptionId", (Object)request.getSubscriptionId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(SubscriptionCollection.class, ListSubscriptionsResponse.Builder::subscriptionCollection).handleResponseHeaderString("opc-next-page", ListSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListSubscriptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public SubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)SubscriptionAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(SubscriptionAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)SubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)SubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)SubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)SubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public SubscriptionAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)SubscriptionAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, SubscriptionAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public SubscriptionAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new SubscriptionAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

