/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationPaginators;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitation;
import com.oracle.bmc.tenantmanagercontrolplane.model.RecipientInvitationCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AcceptRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.IgnoreRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AcceptRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.IgnoreRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateRecipientInvitationResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientInvitationClient
extends BaseSyncClient
implements com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitation {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RECIPIENTINVITATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RecipientInvitationAsyncClient.class);
    private final RecipientInvitationWaiters waiters;
    private final RecipientInvitationPaginators paginators;

    private RecipientInvitationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("RecipientInvitation-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new RecipientInvitationWaiters(executorService, this);
        this.paginators = new RecipientInvitationPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AcceptRecipientInvitationResponse acceptRecipientInvitation(AcceptRecipientInvitationRequest request) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return (AcceptRecipientInvitationResponse)this.clientCall(request, AcceptRecipientInvitationResponse::builder).logger(LOG, "acceptRecipientInvitation").serviceDetails("RecipientInvitation", "AcceptRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/RecipientInvitation/AcceptRecipientInvitation").method(Method.POST).requestBuilder(AcceptRecipientInvitationRequest::builder).basePath("/20200801").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).appendPathParam("actions").appendPathParam("accept").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", AcceptRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", AcceptRecipientInvitationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetRecipientInvitationResponse getRecipientInvitation(GetRecipientInvitationRequest request) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return (GetRecipientInvitationResponse)this.clientCall(request, GetRecipientInvitationResponse::builder).logger(LOG, "getRecipientInvitation").serviceDetails("RecipientInvitation", "GetRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/RecipientInvitation/GetRecipientInvitation").method(Method.GET).requestBuilder(GetRecipientInvitationRequest::builder).basePath("/20200801").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitation.class, GetRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", GetRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRecipientInvitationResponse.Builder::etag).callSync();
    }

    @Override
    public IgnoreRecipientInvitationResponse ignoreRecipientInvitation(IgnoreRecipientInvitationRequest request) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        return (IgnoreRecipientInvitationResponse)this.clientCall(request, IgnoreRecipientInvitationResponse::builder).logger(LOG, "ignoreRecipientInvitation").serviceDetails("RecipientInvitation", "IgnoreRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/RecipientInvitation/IgnoreRecipientInvitation").method(Method.POST).requestBuilder(IgnoreRecipientInvitationRequest::builder).basePath("/20200801").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).appendPathParam("actions").appendPathParam("ignore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitation.class, IgnoreRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", IgnoreRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", IgnoreRecipientInvitationResponse.Builder::etag).callSync();
    }

    @Override
    public ListRecipientInvitationsResponse listRecipientInvitations(ListRecipientInvitationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRecipientInvitationsResponse)this.clientCall(request, ListRecipientInvitationsResponse::builder).logger(LOG, "listRecipientInvitations").serviceDetails("RecipientInvitation", "ListRecipientInvitations", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/RecipientInvitation/ListRecipientInvitations").method(Method.GET).requestBuilder(ListRecipientInvitationsRequest::builder).basePath("/20200801").appendPathParam("recipientInvitations").appendQueryParam("senderTenancyId", (Object)request.getSenderTenancyId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecipientInvitationCollection.class, ListRecipientInvitationsResponse.Builder::recipientInvitationCollection).handleResponseHeaderString("opc-next-page", ListRecipientInvitationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListRecipientInvitationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRecipientInvitationResponse updateRecipientInvitation(UpdateRecipientInvitationRequest request) {
        Validate.notBlank((String)request.getRecipientInvitationId(), (String)"recipientInvitationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecipientInvitationDetails(), "updateRecipientInvitationDetails is required");
        return (UpdateRecipientInvitationResponse)this.clientCall(request, UpdateRecipientInvitationResponse::builder).logger(LOG, "updateRecipientInvitation").serviceDetails("RecipientInvitation", "UpdateRecipientInvitation", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/RecipientInvitation/UpdateRecipientInvitation").method(Method.PUT).requestBuilder(UpdateRecipientInvitationRequest::builder).basePath("/20200801").appendPathParam("recipientInvitations").appendPathParam(request.getRecipientInvitationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RecipientInvitation.class, UpdateRecipientInvitationResponse.Builder::recipientInvitation).handleResponseHeaderString("opc-request-id", UpdateRecipientInvitationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateRecipientInvitationResponse.Builder::etag).callSync();
    }

    @Override
    public RecipientInvitationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public RecipientInvitationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public RecipientInvitationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RecipientInvitationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RecipientInvitationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public RecipientInvitationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RecipientInvitationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RecipientInvitationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public RecipientInvitationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RecipientInvitationClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

