/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.tenantmanagercontrolplane.Organization;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationSummary;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancySummary;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationTenanciesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationTenanciesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class OrganizationPaginators {
    private final Organization client;

    public OrganizationPaginators(Organization client) {
        this.client = client;
    }

    public Iterable<ListOrganizationTenanciesResponse> listOrganizationTenanciesResponseIterator(final ListOrganizationTenanciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOrganizationTenanciesRequest.Builder>(){

            @Override
            public ListOrganizationTenanciesRequest.Builder get() {
                return ListOrganizationTenanciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOrganizationTenanciesResponse, String>(){

            @Override
            public String apply(ListOrganizationTenanciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOrganizationTenanciesRequest.Builder>, ListOrganizationTenanciesRequest>(){

            @Override
            public ListOrganizationTenanciesRequest apply(RequestBuilderAndToken<ListOrganizationTenanciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOrganizationTenanciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOrganizationTenanciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOrganizationTenanciesRequest, ListOrganizationTenanciesResponse>(){

            @Override
            public ListOrganizationTenanciesResponse apply(ListOrganizationTenanciesRequest request) {
                return OrganizationPaginators.this.client.listOrganizationTenancies(request);
            }
        });
    }

    public Iterable<OrganizationTenancySummary> listOrganizationTenanciesRecordIterator(final ListOrganizationTenanciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOrganizationTenanciesRequest.Builder>(){

            @Override
            public ListOrganizationTenanciesRequest.Builder get() {
                return ListOrganizationTenanciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOrganizationTenanciesResponse, String>(){

            @Override
            public String apply(ListOrganizationTenanciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOrganizationTenanciesRequest.Builder>, ListOrganizationTenanciesRequest>(){

            @Override
            public ListOrganizationTenanciesRequest apply(RequestBuilderAndToken<ListOrganizationTenanciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOrganizationTenanciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOrganizationTenanciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOrganizationTenanciesRequest, ListOrganizationTenanciesResponse>(){

            @Override
            public ListOrganizationTenanciesResponse apply(ListOrganizationTenanciesRequest request) {
                return OrganizationPaginators.this.client.listOrganizationTenancies(request);
            }
        }, (Function)new Function<ListOrganizationTenanciesResponse, List<OrganizationTenancySummary>>(){

            @Override
            public List<OrganizationTenancySummary> apply(ListOrganizationTenanciesResponse response) {
                return response.getOrganizationTenancyCollection().getItems();
            }
        });
    }

    public Iterable<ListOrganizationsResponse> listOrganizationsResponseIterator(final ListOrganizationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOrganizationsRequest.Builder>(){

            @Override
            public ListOrganizationsRequest.Builder get() {
                return ListOrganizationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOrganizationsResponse, String>(){

            @Override
            public String apply(ListOrganizationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOrganizationsRequest.Builder>, ListOrganizationsRequest>(){

            @Override
            public ListOrganizationsRequest apply(RequestBuilderAndToken<ListOrganizationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOrganizationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOrganizationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOrganizationsRequest, ListOrganizationsResponse>(){

            @Override
            public ListOrganizationsResponse apply(ListOrganizationsRequest request) {
                return OrganizationPaginators.this.client.listOrganizations(request);
            }
        });
    }

    public Iterable<OrganizationSummary> listOrganizationsRecordIterator(final ListOrganizationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOrganizationsRequest.Builder>(){

            @Override
            public ListOrganizationsRequest.Builder get() {
                return ListOrganizationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOrganizationsResponse, String>(){

            @Override
            public String apply(ListOrganizationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOrganizationsRequest.Builder>, ListOrganizationsRequest>(){

            @Override
            public ListOrganizationsRequest apply(RequestBuilderAndToken<ListOrganizationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListOrganizationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOrganizationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListOrganizationsRequest, ListOrganizationsResponse>(){

            @Override
            public ListOrganizationsResponse apply(ListOrganizationsRequest request) {
                return OrganizationPaginators.this.client.listOrganizations(request);
            }
        }, (Function)new Function<ListOrganizationsResponse, List<OrganizationSummary>>(){

            @Override
            public List<OrganizationSummary> apply(ListOrganizationsResponse response) {
                return response.getOrganizationCollection().getItems();
            }
        });
    }
}

