/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.tenantmanagercontrolplane.Organization;
import com.oracle.bmc.tenantmanagercontrolplane.OrganizationAsyncClient;
import com.oracle.bmc.tenantmanagercontrolplane.OrganizationPaginators;
import com.oracle.bmc.tenantmanagercontrolplane.OrganizationWaiters;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationCollection;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancy;
import com.oracle.bmc.tenantmanagercontrolplane.model.OrganizationTenancyCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ApproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateChildTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationTenanciesRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListOrganizationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.RestoreOrganizationTenancyRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UnapproveOrganizationTenancyForTransferRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateOrganizationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ApproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateChildTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationTenanciesResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListOrganizationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.RestoreOrganizationTenancyResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UnapproveOrganizationTenancyForTransferResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateOrganizationResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationClient
extends BaseSyncClient
implements Organization {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ORGANIZATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(OrganizationAsyncClient.class);
    private final OrganizationWaiters waiters;
    private final OrganizationPaginators paginators;

    private OrganizationClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Organization-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OrganizationWaiters(executorService, this);
        this.paginators = new OrganizationPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ApproveOrganizationTenancyForTransferResponse approveOrganizationTenancyForTransfer(ApproveOrganizationTenancyForTransferRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (ApproveOrganizationTenancyForTransferResponse)this.clientCall(request, ApproveOrganizationTenancyForTransferResponse::builder).logger(LOG, "approveOrganizationTenancyForTransfer").serviceDetails("Organization", "ApproveOrganizationTenancyForTransfer", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/OrganizationTenancy/ApproveOrganizationTenancyForTransfer").method(Method.POST).requestBuilder(ApproveOrganizationTenancyForTransferRequest::builder).basePath("/20200801").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("approveForTransfer").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, ApproveOrganizationTenancyForTransferResponse.Builder::organizationTenancy).handleResponseHeaderString("opc-request-id", ApproveOrganizationTenancyForTransferResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ApproveOrganizationTenancyForTransferResponse.Builder::etag).callSync();
    }

    @Override
    public CreateChildTenancyResponse createChildTenancy(CreateChildTenancyRequest request) {
        Objects.requireNonNull(request.getCreateChildTenancyDetails(), "createChildTenancyDetails is required");
        return (CreateChildTenancyResponse)this.clientCall(request, CreateChildTenancyResponse::builder).logger(LOG, "createChildTenancy").serviceDetails("Organization", "CreateChildTenancy", "").method(Method.POST).requestBuilder(CreateChildTenancyRequest::builder).basePath("/20200801").appendPathParam("childTenancies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", CreateChildTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateChildTenancyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteOrganizationTenancyResponse deleteOrganizationTenancy(DeleteOrganizationTenancyRequest request) {
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (DeleteOrganizationTenancyResponse)this.clientCall(request, DeleteOrganizationTenancyResponse::builder).logger(LOG, "deleteOrganizationTenancy").serviceDetails("Organization", "DeleteOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/OrganizationTenancy/DeleteOrganizationTenancy").method(Method.DELETE).requestBuilder(DeleteOrganizationTenancyRequest::builder).basePath("/20200801").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteOrganizationTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteOrganizationTenancyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetOrganizationResponse getOrganization(GetOrganizationRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        return (GetOrganizationResponse)this.clientCall(request, GetOrganizationResponse::builder).logger(LOG, "getOrganization").serviceDetails("Organization", "GetOrganization", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Organization/GetOrganization").method(Method.GET).requestBuilder(GetOrganizationRequest::builder).basePath("/20200801").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.tenantmanagercontrolplane.model.Organization.class, GetOrganizationResponse.Builder::organization).handleResponseHeaderString("etag", GetOrganizationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOrganizationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOrganizationTenancyResponse getOrganizationTenancy(GetOrganizationTenancyRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getTenancyId(), (String)"tenancyId must not be blank", (Object[])new Object[0]);
        return (GetOrganizationTenancyResponse)this.clientCall(request, GetOrganizationTenancyResponse::builder).logger(LOG, "getOrganizationTenancy").serviceDetails("Organization", "GetOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/OrganizationTenancy/GetOrganizationTenancy").method(Method.GET).requestBuilder(GetOrganizationTenancyRequest::builder).basePath("/20200801").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendPathParam(request.getTenancyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, GetOrganizationTenancyResponse.Builder::organizationTenancy).handleResponseHeaderString("etag", GetOrganizationTenancyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOrganizationTenancyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOrganizationTenanciesResponse listOrganizationTenancies(ListOrganizationTenanciesRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        return (ListOrganizationTenanciesResponse)this.clientCall(request, ListOrganizationTenanciesResponse::builder).logger(LOG, "listOrganizationTenancies").serviceDetails("Organization", "ListOrganizationTenancies", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Organization/ListOrganizationTenancies").method(Method.GET).requestBuilder(ListOrganizationTenanciesRequest::builder).basePath("/20200801").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).appendPathParam("tenancies").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancyCollection.class, ListOrganizationTenanciesResponse.Builder::organizationTenancyCollection).handleResponseHeaderString("opc-next-page", ListOrganizationTenanciesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationTenanciesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOrganizationsResponse listOrganizations(ListOrganizationsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListOrganizationsResponse)this.clientCall(request, ListOrganizationsResponse::builder).logger(LOG, "listOrganizations").serviceDetails("Organization", "ListOrganizations", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Organization/ListOrganizations").method(Method.GET).requestBuilder(ListOrganizationsRequest::builder).basePath("/20200801").appendPathParam("organizations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationCollection.class, ListOrganizationsResponse.Builder::organizationCollection).handleResponseHeaderString("opc-next-page", ListOrganizationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListOrganizationsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RestoreOrganizationTenancyResponse restoreOrganizationTenancy(RestoreOrganizationTenancyRequest request) {
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (RestoreOrganizationTenancyResponse)this.clientCall(request, RestoreOrganizationTenancyResponse::builder).logger(LOG, "restoreOrganizationTenancy").serviceDetails("Organization", "RestoreOrganizationTenancy", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/OrganizationTenancy/RestoreOrganizationTenancy").method(Method.POST).requestBuilder(RestoreOrganizationTenancyRequest::builder).basePath("/20200801").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("restore").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", RestoreOrganizationTenancyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RestoreOrganizationTenancyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UnapproveOrganizationTenancyForTransferResponse unapproveOrganizationTenancyForTransfer(UnapproveOrganizationTenancyForTransferRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getOrganizationTenancyId(), (String)"organizationTenancyId must not be blank", (Object[])new Object[0]);
        return (UnapproveOrganizationTenancyForTransferResponse)this.clientCall(request, UnapproveOrganizationTenancyForTransferResponse::builder).logger(LOG, "unapproveOrganizationTenancyForTransfer").serviceDetails("Organization", "UnapproveOrganizationTenancyForTransfer", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/OrganizationTenancy/UnapproveOrganizationTenancyForTransfer").method(Method.POST).requestBuilder(UnapproveOrganizationTenancyForTransferRequest::builder).basePath("/20200801").appendPathParam("organizationTenancies").appendPathParam(request.getOrganizationTenancyId()).appendPathParam("actions").appendPathParam("unapproveForTransfer").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OrganizationTenancy.class, UnapproveOrganizationTenancyForTransferResponse.Builder::organizationTenancy).handleResponseHeaderString("opc-request-id", UnapproveOrganizationTenancyForTransferResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UnapproveOrganizationTenancyForTransferResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateOrganizationResponse updateOrganization(UpdateOrganizationRequest request) {
        Validate.notBlank((String)request.getOrganizationId(), (String)"organizationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOrganizationDetails(), "updateOrganizationDetails is required");
        return (UpdateOrganizationResponse)this.clientCall(request, UpdateOrganizationResponse::builder).logger(LOG, "updateOrganization").serviceDetails("Organization", "UpdateOrganization", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Organization/UpdateOrganization").method(Method.PUT).requestBuilder(UpdateOrganizationRequest::builder).basePath("/20200801").appendPathParam("organizations").appendPathParam(request.getOrganizationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", UpdateOrganizationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateOrganizationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public OrganizationWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OrganizationPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OrganizationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OrganizationClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OrganizationClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OrganizationClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OrganizationClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OrganizationClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OrganizationClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OrganizationClient((ClientBuilderBase)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

