/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.DomainAsync;
import com.oracle.bmc.tenantmanagercontrolplane.model.Domain;
import com.oracle.bmc.tenantmanagercontrolplane.model.DomainCollection;
import com.oracle.bmc.tenantmanagercontrolplane.requests.CreateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.DeleteDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListDomainsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateDomainRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.CreateDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.DeleteDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetDomainResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListDomainsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateDomainResponse;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainAsyncClient
extends BaseAsyncClient
implements DomainAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DOMAIN").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DomainAsyncClient.class);

    private DomainAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateDomainResponse> createDomain(CreateDomainRequest request, AsyncHandler<CreateDomainRequest, CreateDomainResponse> handler) {
        Objects.requireNonNull(request.getCreateDomainDetails(), "createDomainDetails is required");
        return this.clientCall(request, CreateDomainResponse::builder).logger(LOG, "createDomain").serviceDetails("Domain", "CreateDomain", "").method(Method.POST).requestBuilder(CreateDomainRequest::builder).basePath("/20200801").appendPathParam("domains").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Domain.class, CreateDomainResponse.Builder::domain).handleResponseHeaderString("opc-request-id", CreateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDomainResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateDomainResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteDomainResponse> deleteDomain(DeleteDomainRequest request, AsyncHandler<DeleteDomainRequest, DeleteDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDomainResponse::builder).logger(LOG, "deleteDomain").serviceDetails("Domain", "DeleteDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Domain/DeleteDomain").method(Method.DELETE).requestBuilder(DeleteDomainRequest::builder).basePath("/20200801").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDomainResponse> getDomain(GetDomainRequest request, AsyncHandler<GetDomainRequest, GetDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDomainResponse::builder).logger(LOG, "getDomain").serviceDetails("Domain", "GetDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Domain/GetDomain").method(Method.GET).requestBuilder(GetDomainRequest::builder).basePath("/20200801").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Domain.class, GetDomainResponse.Builder::domain).handleResponseHeaderString("etag", GetDomainResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDomainResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDomainsResponse> listDomains(ListDomainsRequest request, AsyncHandler<ListDomainsRequest, ListDomainsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDomainsResponse::builder).logger(LOG, "listDomains").serviceDetails("Domain", "ListDomains", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Domain/ListDomains").method(Method.GET).requestBuilder(ListDomainsRequest::builder).basePath("/20200801").appendPathParam("domains").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("domainId", (Object)request.getDomainId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DomainCollection.class, ListDomainsResponse.Builder::domainCollection).handleResponseHeaderString("opc-next-page", ListDomainsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDomainsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDomainResponse> updateDomain(UpdateDomainRequest request, AsyncHandler<UpdateDomainRequest, UpdateDomainResponse> handler) {
        Validate.notBlank((String)request.getDomainId(), (String)"domainId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDomainDetails(), "updateDomainDetails is required");
        return this.clientCall(request, UpdateDomainResponse::builder).logger(LOG, "updateDomain").serviceDetails("Domain", "UpdateDomain", "https://docs.oracle.com/iaas/api/#/en/organizations/20200801/Domain/UpdateDomain").method(Method.PUT).requestBuilder(UpdateDomainRequest::builder).basePath("/20200801").appendPathParam("domains").appendPathParam(request.getDomainId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Domain.class, UpdateDomainResponse.Builder::domain).handleResponseHeaderString("opc-request-id", UpdateDomainResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateDomainResponse.Builder::etag).callAsync(handler);
    }

    @Deprecated
    public DomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DomainAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DomainAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DomainAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DomainAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DomainAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DomainAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DomainAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

