/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.streaming.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.streaming.model.CreateGroupCursorDetails;
import java.util.Objects;

public class CreateGroupCursorRequest
extends BmcRequest<CreateGroupCursorDetails> {
    private String streamId;
    private CreateGroupCursorDetails createGroupCursorDetails;
    private String opcRequestId;

    public String getStreamId() {
        return this.streamId;
    }

    public CreateGroupCursorDetails getCreateGroupCursorDetails() {
        return this.createGroupCursorDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreateGroupCursorDetails getBody$() {
        return this.createGroupCursorDetails;
    }

    public Builder toBuilder() {
        return new Builder().streamId(this.streamId).createGroupCursorDetails(this.createGroupCursorDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",streamId=").append(String.valueOf(this.streamId));
        sb.append(",createGroupCursorDetails=").append(String.valueOf((Object)this.createGroupCursorDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateGroupCursorRequest)) {
            return false;
        }
        CreateGroupCursorRequest other = (CreateGroupCursorRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.streamId, other.streamId) && Objects.equals((Object)this.createGroupCursorDetails, (Object)other.createGroupCursorDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.streamId == null ? 43 : this.streamId.hashCode());
        result = result * 59 + (this.createGroupCursorDetails == null ? 43 : this.createGroupCursorDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateGroupCursorRequest, CreateGroupCursorDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String streamId = null;
        private CreateGroupCursorDetails createGroupCursorDetails = null;
        private String opcRequestId = null;

        public Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public Builder createGroupCursorDetails(CreateGroupCursorDetails createGroupCursorDetails) {
            this.createGroupCursorDetails = createGroupCursorDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateGroupCursorRequest o) {
            this.streamId(o.getStreamId());
            this.createGroupCursorDetails(o.getCreateGroupCursorDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateGroupCursorRequest build() {
            CreateGroupCursorRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateGroupCursorDetails body) {
            this.createGroupCursorDetails(body);
            return this;
        }

        public CreateGroupCursorRequest buildWithoutInvocationCallback() {
            CreateGroupCursorRequest request = new CreateGroupCursorRequest();
            request.streamId = this.streamId;
            request.createGroupCursorDetails = this.createGroupCursorDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

