/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.servicemesh.model.UpdateAccessPolicyDetails;
import java.util.Objects;

public class UpdateAccessPolicyRequest
extends BmcRequest<UpdateAccessPolicyDetails> {
    private String accessPolicyId;
    private UpdateAccessPolicyDetails updateAccessPolicyDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getAccessPolicyId() {
        return this.accessPolicyId;
    }

    public UpdateAccessPolicyDetails getUpdateAccessPolicyDetails() {
        return this.updateAccessPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAccessPolicyDetails getBody$() {
        return this.updateAccessPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().accessPolicyId(this.accessPolicyId).updateAccessPolicyDetails(this.updateAccessPolicyDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",accessPolicyId=").append(String.valueOf(this.accessPolicyId));
        sb.append(",updateAccessPolicyDetails=").append(String.valueOf((Object)this.updateAccessPolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAccessPolicyRequest)) {
            return false;
        }
        UpdateAccessPolicyRequest other = (UpdateAccessPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.accessPolicyId, other.accessPolicyId) && Objects.equals((Object)this.updateAccessPolicyDetails, (Object)other.updateAccessPolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.accessPolicyId == null ? 43 : this.accessPolicyId.hashCode());
        result = result * 59 + (this.updateAccessPolicyDetails == null ? 43 : this.updateAccessPolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAccessPolicyRequest, UpdateAccessPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String accessPolicyId = null;
        private UpdateAccessPolicyDetails updateAccessPolicyDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder accessPolicyId(String accessPolicyId) {
            this.accessPolicyId = accessPolicyId;
            return this;
        }

        public Builder updateAccessPolicyDetails(UpdateAccessPolicyDetails updateAccessPolicyDetails) {
            this.updateAccessPolicyDetails = updateAccessPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAccessPolicyRequest o) {
            this.accessPolicyId(o.getAccessPolicyId());
            this.updateAccessPolicyDetails(o.getUpdateAccessPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAccessPolicyRequest build() {
            UpdateAccessPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAccessPolicyDetails body) {
            this.updateAccessPolicyDetails(body);
            return this;
        }

        public UpdateAccessPolicyRequest buildWithoutInvocationCallback() {
            UpdateAccessPolicyRequest request = new UpdateAccessPolicyRequest();
            request.accessPolicyId = this.accessPolicyId;
            request.updateAccessPolicyDetails = this.updateAccessPolicyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

