/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIngressGatewayRouteTableRequest
extends BmcRequest<Void> {
    private String ingressGatewayRouteTableId;
    private String opcRequestId;

    public String getIngressGatewayRouteTableId() {
        return this.ingressGatewayRouteTableId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().ingressGatewayRouteTableId(this.ingressGatewayRouteTableId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ingressGatewayRouteTableId=").append(String.valueOf(this.ingressGatewayRouteTableId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIngressGatewayRouteTableRequest)) {
            return false;
        }
        GetIngressGatewayRouteTableRequest other = (GetIngressGatewayRouteTableRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ingressGatewayRouteTableId, other.ingressGatewayRouteTableId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ingressGatewayRouteTableId == null ? 43 : this.ingressGatewayRouteTableId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIngressGatewayRouteTableRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ingressGatewayRouteTableId = null;
        private String opcRequestId = null;

        public Builder ingressGatewayRouteTableId(String ingressGatewayRouteTableId) {
            this.ingressGatewayRouteTableId = ingressGatewayRouteTableId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIngressGatewayRouteTableRequest o) {
            this.ingressGatewayRouteTableId(o.getIngressGatewayRouteTableId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIngressGatewayRouteTableRequest build() {
            GetIngressGatewayRouteTableRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIngressGatewayRouteTableRequest buildWithoutInvocationCallback() {
            GetIngressGatewayRouteTableRequest request = new GetIngressGatewayRouteTableRequest();
            request.ingressGatewayRouteTableId = this.ingressGatewayRouteTableId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

