/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemesh.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.servicemesh.model.AccessPolicyTarget;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AccessPolicyRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="source")
    private final AccessPolicyTarget source;
    @JsonProperty(value="destination")
    private final AccessPolicyTarget destination;

    @Deprecated
    @ConstructorProperties(value={"action", "source", "destination"})
    public AccessPolicyRule(Action action, AccessPolicyTarget source, AccessPolicyTarget destination) {
        this.action = action;
        this.source = source;
        this.destination = destination;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Action getAction() {
        return this.action;
    }

    public AccessPolicyTarget getSource() {
        return this.source;
    }

    public AccessPolicyTarget getDestination() {
        return this.destination;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessPolicyRule(");
        sb.append("super=").append(super.toString());
        sb.append("action=").append(String.valueOf((Object)this.action));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", destination=").append(String.valueOf((Object)this.destination));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccessPolicyRule)) {
            return false;
        }
        AccessPolicyRule other = (AccessPolicyRule)((Object)o);
        return Objects.equals((Object)this.action, (Object)other.action) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals((Object)this.destination, (Object)other.destination) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.destination == null ? 43 : this.destination.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Allow("ALLOW"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="source")
        private AccessPolicyTarget source;
        @JsonProperty(value="destination")
        private AccessPolicyTarget destination;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder source(AccessPolicyTarget source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder destination(AccessPolicyTarget destination) {
            this.destination = destination;
            this.__explicitlySet__.add("destination");
            return this;
        }

        public AccessPolicyRule build() {
            AccessPolicyRule model = new AccessPolicyRule(this.action, this.source, this.destination);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AccessPolicyRule model) {
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("destination")) {
                this.destination(model.getDestination());
            }
            return this;
        }
    }
}

