/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceEnvironmentEndPointOverview
extends ExplicitlySetBmcModel {
    @JsonProperty(value="environmentType")
    private final EnvironmentType environmentType;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"environmentType", "url", "description"})
    public ServiceEnvironmentEndPointOverview(EnvironmentType environmentType, String url, String description) {
        this.environmentType = environmentType;
        this.url = url;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public EnvironmentType getEnvironmentType() {
        return this.environmentType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceEnvironmentEndPointOverview(");
        sb.append("super=").append(super.toString());
        sb.append("environmentType=").append(String.valueOf((Object)this.environmentType));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceEnvironmentEndPointOverview)) {
            return false;
        }
        ServiceEnvironmentEndPointOverview other = (ServiceEnvironmentEndPointOverview)((Object)o);
        return Objects.equals((Object)this.environmentType, (Object)other.environmentType) && Objects.equals(this.url, other.url) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.environmentType == null ? 43 : this.environmentType.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum EnvironmentType implements BmcEnum
    {
        InstanceUrlProd("INSTANCE_URL_PROD"),
        InstanceUrlTest("INSTANCE_URL_TEST"),
        InstanceUrlDev("INSTANCE_URL_DEV"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnvironmentType> map;

        private EnvironmentType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnvironmentType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnvironmentType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnvironmentType.class);
            map = new HashMap<String, EnvironmentType>();
            for (EnvironmentType v : EnvironmentType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="environmentType")
        private EnvironmentType environmentType;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder environmentType(EnvironmentType environmentType) {
            this.environmentType = environmentType;
            this.__explicitlySet__.add("environmentType");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public ServiceEnvironmentEndPointOverview build() {
            ServiceEnvironmentEndPointOverview model = new ServiceEnvironmentEndPointOverview(this.environmentType, this.url, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceEnvironmentEndPointOverview model) {
            if (model.wasPropertyExplicitlySet("environmentType")) {
                this.environmentType(model.getEnvironmentType());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

