/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.servicemanagerproxy;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.servicemanagerproxy.ServiceManagerProxy;
import com.oracle.bmc.servicemanagerproxy.model.ServiceEnvironmentSummary;
import com.oracle.bmc.servicemanagerproxy.requests.ListServiceEnvironmentsRequest;
import com.oracle.bmc.servicemanagerproxy.responses.ListServiceEnvironmentsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class ServiceManagerProxyPaginators {
    private final ServiceManagerProxy client;

    public ServiceManagerProxyPaginators(ServiceManagerProxy client) {
        this.client = client;
    }

    public Iterable<ListServiceEnvironmentsResponse> listServiceEnvironmentsResponseIterator(final ListServiceEnvironmentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListServiceEnvironmentsRequest.Builder>(){

            @Override
            public ListServiceEnvironmentsRequest.Builder get() {
                return ListServiceEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceEnvironmentsResponse, String>(){

            @Override
            public String apply(ListServiceEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceEnvironmentsRequest.Builder>, ListServiceEnvironmentsRequest>(){

            @Override
            public ListServiceEnvironmentsRequest apply(RequestBuilderAndToken<ListServiceEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceEnvironmentsRequest, ListServiceEnvironmentsResponse>(){

            @Override
            public ListServiceEnvironmentsResponse apply(ListServiceEnvironmentsRequest request) {
                return ServiceManagerProxyPaginators.this.client.listServiceEnvironments(request);
            }
        });
    }

    public Iterable<ServiceEnvironmentSummary> listServiceEnvironmentsRecordIterator(final ListServiceEnvironmentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListServiceEnvironmentsRequest.Builder>(){

            @Override
            public ListServiceEnvironmentsRequest.Builder get() {
                return ListServiceEnvironmentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListServiceEnvironmentsResponse, String>(){

            @Override
            public String apply(ListServiceEnvironmentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListServiceEnvironmentsRequest.Builder>, ListServiceEnvironmentsRequest>(){

            @Override
            public ListServiceEnvironmentsRequest apply(RequestBuilderAndToken<ListServiceEnvironmentsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListServiceEnvironmentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListServiceEnvironmentsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListServiceEnvironmentsRequest, ListServiceEnvironmentsResponse>(){

            @Override
            public ListServiceEnvironmentsResponse apply(ListServiceEnvironmentsRequest request) {
                return ServiceManagerProxyPaginators.this.client.listServiceEnvironments(request);
            }
        }, (Function)new Function<ListServiceEnvironmentsResponse, List<ServiceEnvironmentSummary>>(){

            @Override
            public List<ServiceEnvironmentSummary> apply(ListServiceEnvironmentsResponse response) {
                return response.getServiceEnvironmentCollection().getItems();
            }
        });
    }
}

