/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.secrets.responses;

import com.oracle.bmc.secrets.model.SecretBundle;
import java.beans.ConstructorProperties;

public class GetSecretBundleResponse {
    private String etag;
    private String opcRequestId;
    private SecretBundle secretBundle;

    @ConstructorProperties(value={"etag", "opcRequestId", "secretBundle"})
    GetSecretBundleResponse(String etag, String opcRequestId, SecretBundle secretBundle) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.secretBundle = secretBundle;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SecretBundle getSecretBundle() {
        return this.secretBundle;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private SecretBundle secretBundle;

        public Builder copy(GetSecretBundleResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.secretBundle(o.getSecretBundle());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder secretBundle(SecretBundle secretBundle) {
            this.secretBundle = secretBundle;
            return this;
        }

        public GetSecretBundleResponse build() {
            return new GetSecretBundleResponse(this.etag, this.opcRequestId, this.secretBundle);
        }

        public String toString() {
            return "GetSecretBundleResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", secretBundle=" + this.secretBundle + ")";
        }
    }
}

