/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRoverEntitlementRequest
extends BmcRequest<Void> {
    private String roverEntitlementId;
    private String compartmentId;
    private String opcRetryToken;
    private String opcRequestId;

    public String getRoverEntitlementId() {
        return this.roverEntitlementId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().roverEntitlementId(this.roverEntitlementId).compartmentId(this.compartmentId).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",roverEntitlementId=").append(String.valueOf(this.roverEntitlementId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRoverEntitlementRequest)) {
            return false;
        }
        GetRoverEntitlementRequest other = (GetRoverEntitlementRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.roverEntitlementId, other.roverEntitlementId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.roverEntitlementId == null ? 43 : this.roverEntitlementId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRoverEntitlementRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String roverEntitlementId = null;
        private String compartmentId = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder roverEntitlementId(String roverEntitlementId) {
            this.roverEntitlementId = roverEntitlementId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRoverEntitlementRequest o) {
            this.roverEntitlementId(o.getRoverEntitlementId());
            this.compartmentId(o.getCompartmentId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRoverEntitlementRequest build() {
            GetRoverEntitlementRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRoverEntitlementRequest buildWithoutInvocationCallback() {
            GetRoverEntitlementRequest request = new GetRoverEntitlementRequest();
            request.roverEntitlementId = this.roverEntitlementId;
            request.compartmentId = this.compartmentId;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

