/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.rover.RoverNode;
import com.oracle.bmc.rover.model.RoverNodeSummary;
import com.oracle.bmc.rover.requests.ListRoverNodesRequest;
import com.oracle.bmc.rover.responses.ListRoverNodesResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RoverNodePaginators {
    private final RoverNode client;

    public RoverNodePaginators(RoverNode client) {
        this.client = client;
    }

    public Iterable<ListRoverNodesResponse> listRoverNodesResponseIterator(final ListRoverNodesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoverNodesRequest.Builder>(){

            @Override
            public ListRoverNodesRequest.Builder get() {
                return ListRoverNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, String>(){

            @Override
            public String apply(ListRoverNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverNodesRequest.Builder>, ListRoverNodesRequest>(){

            @Override
            public ListRoverNodesRequest apply(RequestBuilderAndToken<ListRoverNodesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverNodesRequest, ListRoverNodesResponse>(){

            @Override
            public ListRoverNodesResponse apply(ListRoverNodesRequest request) {
                return RoverNodePaginators.this.client.listRoverNodes(request);
            }
        });
    }

    public Iterable<RoverNodeSummary> listRoverNodesRecordIterator(final ListRoverNodesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoverNodesRequest.Builder>(){

            @Override
            public ListRoverNodesRequest.Builder get() {
                return ListRoverNodesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, String>(){

            @Override
            public String apply(ListRoverNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoverNodesRequest.Builder>, ListRoverNodesRequest>(){

            @Override
            public ListRoverNodesRequest apply(RequestBuilderAndToken<ListRoverNodesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoverNodesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRoverNodesRequest, ListRoverNodesResponse>(){

            @Override
            public ListRoverNodesResponse apply(ListRoverNodesRequest request) {
                return RoverNodePaginators.this.client.listRoverNodes(request);
            }
        }, (Function)new Function<ListRoverNodesResponse, List<RoverNodeSummary>>(){

            @Override
            public List<RoverNodeSummary> apply(ListRoverNodesResponse response) {
                return response.getRoverNodeCollection().getItems();
            }
        });
    }
}

