/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.rover;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.rover.RoverClusterAsync;
import com.oracle.bmc.rover.model.RoverCluster;
import com.oracle.bmc.rover.model.RoverClusterCertificate;
import com.oracle.bmc.rover.model.RoverClusterCollection;
import com.oracle.bmc.rover.requests.ChangeRoverClusterCompartmentRequest;
import com.oracle.bmc.rover.requests.CreateRoverClusterRequest;
import com.oracle.bmc.rover.requests.DeleteRoverClusterRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterCertificateRequest;
import com.oracle.bmc.rover.requests.GetRoverClusterRequest;
import com.oracle.bmc.rover.requests.ListRoverClustersRequest;
import com.oracle.bmc.rover.requests.UpdateRoverClusterRequest;
import com.oracle.bmc.rover.responses.ChangeRoverClusterCompartmentResponse;
import com.oracle.bmc.rover.responses.CreateRoverClusterResponse;
import com.oracle.bmc.rover.responses.DeleteRoverClusterResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterCertificateResponse;
import com.oracle.bmc.rover.responses.GetRoverClusterResponse;
import com.oracle.bmc.rover.responses.ListRoverClustersResponse;
import com.oracle.bmc.rover.responses.UpdateRoverClusterResponse;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoverClusterAsyncClient
extends BaseAsyncClient
implements RoverClusterAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ROVERCLUSTER").serviceEndpointPrefix("").serviceEndpointTemplate("https://rover.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RoverClusterAsyncClient.class);

    private RoverClusterAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeRoverClusterCompartmentResponse> changeRoverClusterCompartment(ChangeRoverClusterCompartmentRequest request, AsyncHandler<ChangeRoverClusterCompartmentRequest, ChangeRoverClusterCompartmentResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRoverClusterCompartmentDetails(), "changeRoverClusterCompartmentDetails is required");
        return this.clientCall(request, ChangeRoverClusterCompartmentResponse::builder).logger(LOG, "changeRoverClusterCompartment").serviceDetails("RoverCluster", "ChangeRoverClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/ChangeRoverClusterCompartment").method(Method.POST).requestBuilder(ChangeRoverClusterCompartmentRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeRoverClusterCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRoverClusterResponse> createRoverCluster(CreateRoverClusterRequest request, AsyncHandler<CreateRoverClusterRequest, CreateRoverClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateRoverClusterDetails(), "createRoverClusterDetails is required");
        return this.clientCall(request, CreateRoverClusterResponse::builder).logger(LOG, "createRoverCluster").serviceDetails("RoverCluster", "CreateRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/CreateRoverCluster").method(Method.POST).requestBuilder(CreateRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverCluster.class, CreateRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", CreateRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRoverClusterResponse> deleteRoverCluster(DeleteRoverClusterRequest request, AsyncHandler<DeleteRoverClusterRequest, DeleteRoverClusterResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRoverClusterResponse::builder).logger(LOG, "deleteRoverCluster").serviceDetails("RoverCluster", "DeleteRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/DeleteRoverCluster").method(Method.DELETE).requestBuilder(DeleteRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRoverClusterResponse> getRoverCluster(GetRoverClusterRequest request, AsyncHandler<GetRoverClusterRequest, GetRoverClusterResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRoverClusterResponse::builder).logger(LOG, "getRoverCluster").serviceDetails("RoverCluster", "GetRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/GetRoverCluster").method(Method.GET).requestBuilder(GetRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverCluster.class, GetRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", GetRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRoverClusterCertificateResponse> getRoverClusterCertificate(GetRoverClusterCertificateRequest request, AsyncHandler<GetRoverClusterCertificateRequest, GetRoverClusterCertificateResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRoverClusterCertificateResponse::builder).logger(LOG, "getRoverClusterCertificate").serviceDetails("RoverCluster", "GetRoverClusterCertificate", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverClusterCertificate/GetRoverClusterCertificate").method(Method.GET).requestBuilder(GetRoverClusterCertificateRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).appendPathParam("certificate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverClusterCertificate.class, GetRoverClusterCertificateResponse.Builder::roverClusterCertificate).handleResponseHeaderString("etag", GetRoverClusterCertificateResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRoverClusterCertificateResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListRoverClustersResponse> listRoverClusters(ListRoverClustersRequest request, AsyncHandler<ListRoverClustersRequest, ListRoverClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListRoverClustersResponse::builder).logger(LOG, "listRoverClusters").serviceDetails("RoverCluster", "ListRoverClusters", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/ListRoverClusters").method(Method.GET).requestBuilder(ListRoverClustersRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("clusterType", (BmcEnum)request.getClusterType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RoverClusterCollection.class, ListRoverClustersResponse.Builder::roverClusterCollection).handleResponseHeaderString("opc-request-id", ListRoverClustersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRoverClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-prev-page", ListRoverClustersResponse.Builder::opcPrevPage).callAsync(handler);
    }

    @Override
    public Future<UpdateRoverClusterResponse> updateRoverCluster(UpdateRoverClusterRequest request, AsyncHandler<UpdateRoverClusterRequest, UpdateRoverClusterResponse> handler) {
        Validate.notBlank((String)request.getRoverClusterId(), (String)"roverClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRoverClusterDetails(), "updateRoverClusterDetails is required");
        return this.clientCall(request, UpdateRoverClusterResponse::builder).logger(LOG, "updateRoverCluster").serviceDetails("RoverCluster", "UpdateRoverCluster", "https://docs.oracle.com/iaas/api/#/en/rover/20201210/RoverCluster/UpdateRoverCluster").method(Method.PUT).requestBuilder(UpdateRoverClusterRequest::builder).basePath("/20201210").appendPathParam("roverClusters").appendPathParam(request.getRoverClusterId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(RoverCluster.class, UpdateRoverClusterResponse.Builder::roverCluster).handleResponseHeaderString("etag", UpdateRoverClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRoverClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RoverClusterAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RoverClusterAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RoverClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RoverClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RoverClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RoverClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RoverClusterAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RoverClusterAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RoverClusterAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RoverClusterAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RoverClusterAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

