/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.resourcemanager.model.LogEntry;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetJobLogsRequest
extends BmcRequest<Void> {
    private String jobId;
    private String opcRequestId;
    private List<LogEntry.Type> type;
    private LogEntry.Level levelGreaterThanOrEqualTo;
    private SortOrder sortOrder;
    private Integer limit;
    private String page;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThanOrEqualTo;

    public String getJobId() {
        return this.jobId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<LogEntry.Type> getType() {
        return this.type;
    }

    public LogEntry.Level getLevelGreaterThanOrEqualTo() {
        return this.levelGreaterThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThanOrEqualTo() {
        return this.timestampLessThanOrEqualTo;
    }

    public Builder toBuilder() {
        return new Builder().jobId(this.jobId).opcRequestId(this.opcRequestId).type(this.type).levelGreaterThanOrEqualTo(this.levelGreaterThanOrEqualTo).sortOrder(this.sortOrder).limit(this.limit).page(this.page).timestampGreaterThanOrEqualTo(this.timestampGreaterThanOrEqualTo).timestampLessThanOrEqualTo(this.timestampLessThanOrEqualTo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",jobId=").append(String.valueOf(this.jobId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",type=").append(String.valueOf(this.type));
        sb.append(",levelGreaterThanOrEqualTo=").append(String.valueOf((Object)this.levelGreaterThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",timestampGreaterThanOrEqualTo=").append(String.valueOf(this.timestampGreaterThanOrEqualTo));
        sb.append(",timestampLessThanOrEqualTo=").append(String.valueOf(this.timestampLessThanOrEqualTo));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetJobLogsRequest)) {
            return false;
        }
        GetJobLogsRequest other = (GetJobLogsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.type, other.type) && Objects.equals((Object)this.levelGreaterThanOrEqualTo, (Object)other.levelGreaterThanOrEqualTo) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.timestampGreaterThanOrEqualTo, other.timestampGreaterThanOrEqualTo) && Objects.equals(this.timestampLessThanOrEqualTo, other.timestampLessThanOrEqualTo);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.jobId == null ? 43 : this.jobId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.levelGreaterThanOrEqualTo == null ? 43 : this.levelGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.timestampGreaterThanOrEqualTo == null ? 43 : this.timestampGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timestampLessThanOrEqualTo == null ? 43 : this.timestampLessThanOrEqualTo.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobLogsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String jobId = null;
        private String opcRequestId = null;
        private List<LogEntry.Type> type = null;
        private LogEntry.Level levelGreaterThanOrEqualTo = null;
        private SortOrder sortOrder = null;
        private Integer limit = null;
        private String page = null;
        private Date timestampGreaterThanOrEqualTo = null;
        private Date timestampLessThanOrEqualTo = null;

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder type(List<LogEntry.Type> type) {
            this.type = type;
            return this;
        }

        public Builder type(LogEntry.Type singularValue) {
            return this.type(Arrays.asList(singularValue));
        }

        public Builder levelGreaterThanOrEqualTo(LogEntry.Level levelGreaterThanOrEqualTo) {
            this.levelGreaterThanOrEqualTo = levelGreaterThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThanOrEqualTo(Date timestampLessThanOrEqualTo) {
            this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobLogsRequest o) {
            this.jobId(o.getJobId());
            this.opcRequestId(o.getOpcRequestId());
            this.type(o.getType());
            this.levelGreaterThanOrEqualTo(o.getLevelGreaterThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThanOrEqualTo(o.getTimestampLessThanOrEqualTo());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobLogsRequest build() {
            GetJobLogsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetJobLogsRequest buildWithoutInvocationCallback() {
            GetJobLogsRequest request = new GetJobLogsRequest();
            request.jobId = this.jobId;
            request.opcRequestId = this.opcRequestId;
            request.type = this.type;
            request.levelGreaterThanOrEqualTo = this.levelGreaterThanOrEqualTo;
            request.sortOrder = this.sortOrder;
            request.limit = this.limit;
            request.page = this.page;
            request.timestampGreaterThanOrEqualTo = this.timestampGreaterThanOrEqualTo;
            request.timestampLessThanOrEqualTo = this.timestampLessThanOrEqualTo;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

