/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdatePrivateEndpointDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="vcnId")
    private final String vcnId;
    @JsonProperty(value="subnetId")
    private final String subnetId;
    @JsonProperty(value="dnsZones")
    private final List<String> dnsZones;
    @JsonProperty(value="nsgIdList")
    private final List<String> nsgIdList;
    @JsonProperty(value="isUsedWithConfigurationSourceProvider")
    private final Boolean isUsedWithConfigurationSourceProvider;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "vcnId", "subnetId", "dnsZones", "nsgIdList", "isUsedWithConfigurationSourceProvider", "freeformTags", "definedTags"})
    public UpdatePrivateEndpointDetails(String displayName, String description, String vcnId, String subnetId, List<String> dnsZones, List<String> nsgIdList, Boolean isUsedWithConfigurationSourceProvider, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.description = description;
        this.vcnId = vcnId;
        this.subnetId = subnetId;
        this.dnsZones = dnsZones;
        this.nsgIdList = nsgIdList;
        this.isUsedWithConfigurationSourceProvider = isUsedWithConfigurationSourceProvider;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVcnId() {
        return this.vcnId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public List<String> getDnsZones() {
        return this.dnsZones;
    }

    public List<String> getNsgIdList() {
        return this.nsgIdList;
    }

    public Boolean getIsUsedWithConfigurationSourceProvider() {
        return this.isUsedWithConfigurationSourceProvider;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdatePrivateEndpointDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", vcnId=").append(String.valueOf(this.vcnId));
        sb.append(", subnetId=").append(String.valueOf(this.subnetId));
        sb.append(", dnsZones=").append(String.valueOf(this.dnsZones));
        sb.append(", nsgIdList=").append(String.valueOf(this.nsgIdList));
        sb.append(", isUsedWithConfigurationSourceProvider=").append(String.valueOf(this.isUsedWithConfigurationSourceProvider));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdatePrivateEndpointDetails)) {
            return false;
        }
        UpdatePrivateEndpointDetails other = (UpdatePrivateEndpointDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.vcnId, other.vcnId) && Objects.equals(this.subnetId, other.subnetId) && Objects.equals(this.dnsZones, other.dnsZones) && Objects.equals(this.nsgIdList, other.nsgIdList) && Objects.equals(this.isUsedWithConfigurationSourceProvider, other.isUsedWithConfigurationSourceProvider) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.vcnId == null ? 43 : this.vcnId.hashCode());
        result = result * 59 + (this.subnetId == null ? 43 : this.subnetId.hashCode());
        result = result * 59 + (this.dnsZones == null ? 43 : this.dnsZones.hashCode());
        result = result * 59 + (this.nsgIdList == null ? 43 : this.nsgIdList.hashCode());
        result = result * 59 + (this.isUsedWithConfigurationSourceProvider == null ? 43 : this.isUsedWithConfigurationSourceProvider.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="vcnId")
        private String vcnId;
        @JsonProperty(value="subnetId")
        private String subnetId;
        @JsonProperty(value="dnsZones")
        private List<String> dnsZones;
        @JsonProperty(value="nsgIdList")
        private List<String> nsgIdList;
        @JsonProperty(value="isUsedWithConfigurationSourceProvider")
        private Boolean isUsedWithConfigurationSourceProvider;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder vcnId(String vcnId) {
            this.vcnId = vcnId;
            this.__explicitlySet__.add("vcnId");
            return this;
        }

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            this.__explicitlySet__.add("subnetId");
            return this;
        }

        public Builder dnsZones(List<String> dnsZones) {
            this.dnsZones = dnsZones;
            this.__explicitlySet__.add("dnsZones");
            return this;
        }

        public Builder nsgIdList(List<String> nsgIdList) {
            this.nsgIdList = nsgIdList;
            this.__explicitlySet__.add("nsgIdList");
            return this;
        }

        public Builder isUsedWithConfigurationSourceProvider(Boolean isUsedWithConfigurationSourceProvider) {
            this.isUsedWithConfigurationSourceProvider = isUsedWithConfigurationSourceProvider;
            this.__explicitlySet__.add("isUsedWithConfigurationSourceProvider");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdatePrivateEndpointDetails build() {
            UpdatePrivateEndpointDetails model = new UpdatePrivateEndpointDetails(this.displayName, this.description, this.vcnId, this.subnetId, this.dnsZones, this.nsgIdList, this.isUsedWithConfigurationSourceProvider, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdatePrivateEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("vcnId")) {
                this.vcnId(model.getVcnId());
            }
            if (model.wasPropertyExplicitlySet("subnetId")) {
                this.subnetId(model.getSubnetId());
            }
            if (model.wasPropertyExplicitlySet("dnsZones")) {
                this.dnsZones(model.getDnsZones());
            }
            if (model.wasPropertyExplicitlySet("nsgIdList")) {
                this.nsgIdList(model.getNsgIdList());
            }
            if (model.wasPropertyExplicitlySet("isUsedWithConfigurationSourceProvider")) {
                this.isUsedWithConfigurationSourceProvider(model.getIsUsedWithConfigurationSourceProvider());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

