/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.resourcemanager.model.ConfigSource;
import com.oracle.bmc.resourcemanager.model.CustomTerraformProvider;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Stack
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="configSource")
    private final ConfigSource configSource;
    @JsonProperty(value="customTerraformProvider")
    private final CustomTerraformProvider customTerraformProvider;
    @JsonProperty(value="isThirdPartyProviderExperienceEnabled")
    private final Boolean isThirdPartyProviderExperienceEnabled;
    @JsonProperty(value="variables")
    private final Map<String, String> variables;
    @JsonProperty(value="terraformVersion")
    private final String terraformVersion;
    @JsonProperty(value="stackDriftStatus")
    private final StackDriftStatus stackDriftStatus;
    @JsonProperty(value="timeDriftLastChecked")
    private final Date timeDriftLastChecked;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "timeCreated", "lifecycleState", "configSource", "customTerraformProvider", "isThirdPartyProviderExperienceEnabled", "variables", "terraformVersion", "stackDriftStatus", "timeDriftLastChecked", "freeformTags", "definedTags"})
    public Stack(String id, String compartmentId, String displayName, String description, Date timeCreated, LifecycleState lifecycleState, ConfigSource configSource, CustomTerraformProvider customTerraformProvider, Boolean isThirdPartyProviderExperienceEnabled, Map<String, String> variables, String terraformVersion, StackDriftStatus stackDriftStatus, Date timeDriftLastChecked, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.configSource = configSource;
        this.customTerraformProvider = customTerraformProvider;
        this.isThirdPartyProviderExperienceEnabled = isThirdPartyProviderExperienceEnabled;
        this.variables = variables;
        this.terraformVersion = terraformVersion;
        this.stackDriftStatus = stackDriftStatus;
        this.timeDriftLastChecked = timeDriftLastChecked;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public ConfigSource getConfigSource() {
        return this.configSource;
    }

    public CustomTerraformProvider getCustomTerraformProvider() {
        return this.customTerraformProvider;
    }

    public Boolean getIsThirdPartyProviderExperienceEnabled() {
        return this.isThirdPartyProviderExperienceEnabled;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public String getTerraformVersion() {
        return this.terraformVersion;
    }

    public StackDriftStatus getStackDriftStatus() {
        return this.stackDriftStatus;
    }

    public Date getTimeDriftLastChecked() {
        return this.timeDriftLastChecked;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Stack(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", configSource=").append(String.valueOf((Object)this.configSource));
        sb.append(", customTerraformProvider=").append(String.valueOf((Object)this.customTerraformProvider));
        sb.append(", isThirdPartyProviderExperienceEnabled=").append(String.valueOf(this.isThirdPartyProviderExperienceEnabled));
        sb.append(", variables=").append(String.valueOf(this.variables));
        sb.append(", terraformVersion=").append(String.valueOf(this.terraformVersion));
        sb.append(", stackDriftStatus=").append(String.valueOf((Object)this.stackDriftStatus));
        sb.append(", timeDriftLastChecked=").append(String.valueOf(this.timeDriftLastChecked));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.configSource, (Object)other.configSource) && Objects.equals((Object)this.customTerraformProvider, (Object)other.customTerraformProvider) && Objects.equals(this.isThirdPartyProviderExperienceEnabled, other.isThirdPartyProviderExperienceEnabled) && Objects.equals(this.variables, other.variables) && Objects.equals(this.terraformVersion, other.terraformVersion) && Objects.equals((Object)this.stackDriftStatus, (Object)other.stackDriftStatus) && Objects.equals(this.timeDriftLastChecked, other.timeDriftLastChecked) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.configSource == null ? 43 : this.configSource.hashCode());
        result = result * 59 + (this.customTerraformProvider == null ? 43 : this.customTerraformProvider.hashCode());
        result = result * 59 + (this.isThirdPartyProviderExperienceEnabled == null ? 43 : this.isThirdPartyProviderExperienceEnabled.hashCode());
        result = result * 59 + (this.variables == null ? 43 : this.variables.hashCode());
        result = result * 59 + (this.terraformVersion == null ? 43 : this.terraformVersion.hashCode());
        result = result * 59 + (this.stackDriftStatus == null ? 43 : this.stackDriftStatus.hashCode());
        result = result * 59 + (this.timeDriftLastChecked == null ? 43 : this.timeDriftLastChecked.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum StackDriftStatus implements BmcEnum
    {
        NotChecked("NOT_CHECKED"),
        InSync("IN_SYNC"),
        Drifted("DRIFTED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, StackDriftStatus> map;

        private StackDriftStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static StackDriftStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'StackDriftStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(StackDriftStatus.class);
            map = new HashMap<String, StackDriftStatus>();
            for (StackDriftStatus v : StackDriftStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="configSource")
        private ConfigSource configSource;
        @JsonProperty(value="customTerraformProvider")
        private CustomTerraformProvider customTerraformProvider;
        @JsonProperty(value="isThirdPartyProviderExperienceEnabled")
        private Boolean isThirdPartyProviderExperienceEnabled;
        @JsonProperty(value="variables")
        private Map<String, String> variables;
        @JsonProperty(value="terraformVersion")
        private String terraformVersion;
        @JsonProperty(value="stackDriftStatus")
        private StackDriftStatus stackDriftStatus;
        @JsonProperty(value="timeDriftLastChecked")
        private Date timeDriftLastChecked;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder configSource(ConfigSource configSource) {
            this.configSource = configSource;
            this.__explicitlySet__.add("configSource");
            return this;
        }

        public Builder customTerraformProvider(CustomTerraformProvider customTerraformProvider) {
            this.customTerraformProvider = customTerraformProvider;
            this.__explicitlySet__.add("customTerraformProvider");
            return this;
        }

        public Builder isThirdPartyProviderExperienceEnabled(Boolean isThirdPartyProviderExperienceEnabled) {
            this.isThirdPartyProviderExperienceEnabled = isThirdPartyProviderExperienceEnabled;
            this.__explicitlySet__.add("isThirdPartyProviderExperienceEnabled");
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.variables = variables;
            this.__explicitlySet__.add("variables");
            return this;
        }

        public Builder terraformVersion(String terraformVersion) {
            this.terraformVersion = terraformVersion;
            this.__explicitlySet__.add("terraformVersion");
            return this;
        }

        public Builder stackDriftStatus(StackDriftStatus stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
            this.__explicitlySet__.add("stackDriftStatus");
            return this;
        }

        public Builder timeDriftLastChecked(Date timeDriftLastChecked) {
            this.timeDriftLastChecked = timeDriftLastChecked;
            this.__explicitlySet__.add("timeDriftLastChecked");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Stack build() {
            Stack model = new Stack(this.id, this.compartmentId, this.displayName, this.description, this.timeCreated, this.lifecycleState, this.configSource, this.customTerraformProvider, this.isThirdPartyProviderExperienceEnabled, this.variables, this.terraformVersion, this.stackDriftStatus, this.timeDriftLastChecked, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Stack model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("configSource")) {
                this.configSource(model.getConfigSource());
            }
            if (model.wasPropertyExplicitlySet("customTerraformProvider")) {
                this.customTerraformProvider(model.getCustomTerraformProvider());
            }
            if (model.wasPropertyExplicitlySet("isThirdPartyProviderExperienceEnabled")) {
                this.isThirdPartyProviderExperienceEnabled(model.getIsThirdPartyProviderExperienceEnabled());
            }
            if (model.wasPropertyExplicitlySet("variables")) {
                this.variables(model.getVariables());
            }
            if (model.wasPropertyExplicitlySet("terraformVersion")) {
                this.terraformVersion(model.getTerraformVersion());
            }
            if (model.wasPropertyExplicitlySet("stackDriftStatus")) {
                this.stackDriftStatus(model.getStackDriftStatus());
            }
            if (model.wasPropertyExplicitlySet("timeDriftLastChecked")) {
                this.timeDriftLastChecked(model.getTimeDriftLastChecked());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

