/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JobOutputSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="outputName")
    private final String outputName;
    @JsonProperty(value="outputType")
    private final String outputType;
    @JsonProperty(value="outputValue")
    private final String outputValue;
    @JsonProperty(value="isSensitive")
    private final Boolean isSensitive;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"outputName", "outputType", "outputValue", "isSensitive", "description"})
    public JobOutputSummary(String outputName, String outputType, String outputValue, Boolean isSensitive, String description) {
        this.outputName = outputName;
        this.outputType = outputType;
        this.outputValue = outputValue;
        this.isSensitive = isSensitive;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getOutputName() {
        return this.outputName;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public Boolean getIsSensitive() {
        return this.isSensitive;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobOutputSummary(");
        sb.append("super=").append(super.toString());
        sb.append("outputName=").append(String.valueOf(this.outputName));
        sb.append(", outputType=").append(String.valueOf(this.outputType));
        sb.append(", outputValue=").append(String.valueOf(this.outputValue));
        sb.append(", isSensitive=").append(String.valueOf(this.isSensitive));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobOutputSummary)) {
            return false;
        }
        JobOutputSummary other = (JobOutputSummary)((Object)o);
        return Objects.equals(this.outputName, other.outputName) && Objects.equals(this.outputType, other.outputType) && Objects.equals(this.outputValue, other.outputValue) && Objects.equals(this.isSensitive, other.isSensitive) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.outputName == null ? 43 : this.outputName.hashCode());
        result = result * 59 + (this.outputType == null ? 43 : this.outputType.hashCode());
        result = result * 59 + (this.outputValue == null ? 43 : this.outputValue.hashCode());
        result = result * 59 + (this.isSensitive == null ? 43 : this.isSensitive.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="outputName")
        private String outputName;
        @JsonProperty(value="outputType")
        private String outputType;
        @JsonProperty(value="outputValue")
        private String outputValue;
        @JsonProperty(value="isSensitive")
        private Boolean isSensitive;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder outputName(String outputName) {
            this.outputName = outputName;
            this.__explicitlySet__.add("outputName");
            return this;
        }

        public Builder outputType(String outputType) {
            this.outputType = outputType;
            this.__explicitlySet__.add("outputType");
            return this;
        }

        public Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            this.__explicitlySet__.add("outputValue");
            return this;
        }

        public Builder isSensitive(Boolean isSensitive) {
            this.isSensitive = isSensitive;
            this.__explicitlySet__.add("isSensitive");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public JobOutputSummary build() {
            JobOutputSummary model = new JobOutputSummary(this.outputName, this.outputType, this.outputValue, this.isSensitive, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JobOutputSummary model) {
            if (model.wasPropertyExplicitlySet("outputName")) {
                this.outputName(model.getOutputName());
            }
            if (model.wasPropertyExplicitlySet("outputType")) {
                this.outputType(model.getOutputType());
            }
            if (model.wasPropertyExplicitlySet("outputValue")) {
                this.outputValue(model.getOutputValue());
            }
            if (model.wasPropertyExplicitlySet("isSensitive")) {
                this.isSensitive(model.getIsSensitive());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

