/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.resourcemanager.model.ApplyJobPlanResolution;
import com.oracle.bmc.resourcemanager.model.CreateJobOperationDetails;
import com.oracle.bmc.resourcemanager.model.Job;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="stackId")
    private final String stackId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="operation")
    private final Job.Operation operation;
    @JsonProperty(value="jobOperationDetails")
    private final CreateJobOperationDetails jobOperationDetails;
    @JsonProperty(value="applyJobPlanResolution")
    private final ApplyJobPlanResolution applyJobPlanResolution;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"stackId", "displayName", "operation", "jobOperationDetails", "applyJobPlanResolution", "freeformTags", "definedTags"})
    public CreateJobDetails(String stackId, String displayName, Job.Operation operation, CreateJobOperationDetails jobOperationDetails, ApplyJobPlanResolution applyJobPlanResolution, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.stackId = stackId;
        this.displayName = displayName;
        this.operation = operation;
        this.jobOperationDetails = jobOperationDetails;
        this.applyJobPlanResolution = applyJobPlanResolution;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Job.Operation getOperation() {
        return this.operation;
    }

    public CreateJobOperationDetails getJobOperationDetails() {
        return this.jobOperationDetails;
    }

    public ApplyJobPlanResolution getApplyJobPlanResolution() {
        return this.applyJobPlanResolution;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("stackId=").append(String.valueOf(this.stackId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", operation=").append(String.valueOf((Object)this.operation));
        sb.append(", jobOperationDetails=").append(String.valueOf((Object)this.jobOperationDetails));
        sb.append(", applyJobPlanResolution=").append(String.valueOf((Object)this.applyJobPlanResolution));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateJobDetails)) {
            return false;
        }
        CreateJobDetails other = (CreateJobDetails)((Object)o);
        return Objects.equals(this.stackId, other.stackId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.operation, (Object)other.operation) && Objects.equals((Object)this.jobOperationDetails, (Object)other.jobOperationDetails) && Objects.equals((Object)this.applyJobPlanResolution, (Object)other.applyJobPlanResolution) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.stackId == null ? 43 : this.stackId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.jobOperationDetails == null ? 43 : this.jobOperationDetails.hashCode());
        result = result * 59 + (this.applyJobPlanResolution == null ? 43 : this.applyJobPlanResolution.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="stackId")
        private String stackId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="operation")
        private Job.Operation operation;
        @JsonProperty(value="jobOperationDetails")
        private CreateJobOperationDetails jobOperationDetails;
        @JsonProperty(value="applyJobPlanResolution")
        private ApplyJobPlanResolution applyJobPlanResolution;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder stackId(String stackId) {
            this.stackId = stackId;
            this.__explicitlySet__.add("stackId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder operation(Job.Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder jobOperationDetails(CreateJobOperationDetails jobOperationDetails) {
            this.jobOperationDetails = jobOperationDetails;
            this.__explicitlySet__.add("jobOperationDetails");
            return this;
        }

        public Builder applyJobPlanResolution(ApplyJobPlanResolution applyJobPlanResolution) {
            this.applyJobPlanResolution = applyJobPlanResolution;
            this.__explicitlySet__.add("applyJobPlanResolution");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateJobDetails build() {
            CreateJobDetails model = new CreateJobDetails(this.stackId, this.displayName, this.operation, this.jobOperationDetails, this.applyJobPlanResolution, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateJobDetails model) {
            if (model.wasPropertyExplicitlySet("stackId")) {
                this.stackId(model.getStackId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("jobOperationDetails")) {
                this.jobOperationDetails(model.getJobOperationDetails());
            }
            if (model.wasPropertyExplicitlySet("applyJobPlanResolution")) {
                this.applyJobPlanResolution(model.getApplyJobPlanResolution());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

