/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcemanager;

import com.oracle.bmc.resourcemanager.ResourceManager;
import com.oracle.bmc.resourcemanager.model.ConfigurationSourceProvider;
import com.oracle.bmc.resourcemanager.model.Job;
import com.oracle.bmc.resourcemanager.model.PrivateEndpoint;
import com.oracle.bmc.resourcemanager.model.Stack;
import com.oracle.bmc.resourcemanager.model.Template;
import com.oracle.bmc.resourcemanager.requests.GetConfigurationSourceProviderRequest;
import com.oracle.bmc.resourcemanager.requests.GetJobRequest;
import com.oracle.bmc.resourcemanager.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.resourcemanager.requests.GetStackRequest;
import com.oracle.bmc.resourcemanager.requests.GetTemplateRequest;
import com.oracle.bmc.resourcemanager.requests.GetWorkRequestRequest;
import com.oracle.bmc.resourcemanager.responses.GetConfigurationSourceProviderResponse;
import com.oracle.bmc.resourcemanager.responses.GetJobResponse;
import com.oracle.bmc.resourcemanager.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.resourcemanager.responses.GetStackResponse;
import com.oracle.bmc.resourcemanager.responses.GetTemplateResponse;
import com.oracle.bmc.resourcemanager.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ResourceManagerWaiters {
    private final ExecutorService executorService;
    private final ResourceManager client;

    public ResourceManagerWaiters(ExecutorService executorService, ResourceManager client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> forConfigurationSourceProvider(GetConfigurationSourceProviderRequest request, ConfigurationSourceProvider.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConfigurationSourceProvider(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> forConfigurationSourceProvider(GetConfigurationSourceProviderRequest request, ConfigurationSourceProvider.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConfigurationSourceProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> forConfigurationSourceProvider(GetConfigurationSourceProviderRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ConfigurationSourceProvider.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConfigurationSourceProvider(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse> forConfigurationSourceProvider(BmcGenericWaiter waiter, GetConfigurationSourceProviderRequest request, ConfigurationSourceProvider.LifecycleState ... targetStates) {
        final HashSet<ConfigurationSourceProvider.LifecycleState> targetStatesSet = new HashSet<ConfigurationSourceProvider.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConfigurationSourceProviderRequest, GetConfigurationSourceProviderResponse>(){

            @Override
            public GetConfigurationSourceProviderResponse apply(GetConfigurationSourceProviderRequest request) {
                return ResourceManagerWaiters.this.client.getConfigurationSourceProvider(request);
            }
        }, (Predicate)new Predicate<GetConfigurationSourceProviderResponse>(){

            @Override
            public boolean test(GetConfigurationSourceProviderResponse response) {
                return targetStatesSet.contains((Object)response.getConfigurationSourceProvider().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, Job.LifecycleState ... targetStates) {
        final HashSet<Job.LifecycleState> targetStatesSet = new HashSet<Job.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetJobRequest, GetJobResponse>(){

            @Override
            public GetJobResponse apply(GetJobRequest request) {
                return ResourceManagerWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            @Override
            public boolean test(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(GetPrivateEndpointRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, PrivateEndpoint.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forPrivateEndpoint(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetPrivateEndpointRequest, GetPrivateEndpointResponse> forPrivateEndpoint(BmcGenericWaiter waiter, GetPrivateEndpointRequest request, PrivateEndpoint.LifecycleState ... targetStates) {
        final HashSet<PrivateEndpoint.LifecycleState> targetStatesSet = new HashSet<PrivateEndpoint.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetPrivateEndpointRequest, GetPrivateEndpointResponse>(){

            @Override
            public GetPrivateEndpointResponse apply(GetPrivateEndpointRequest request) {
                return ResourceManagerWaiters.this.client.getPrivateEndpoint(request);
            }
        }, (Predicate)new Predicate<GetPrivateEndpointResponse>(){

            @Override
            public boolean test(GetPrivateEndpointResponse response) {
                return targetStatesSet.contains((Object)response.getPrivateEndpoint().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)PrivateEndpoint.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, Stack.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forStack(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, Stack.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forStack(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetStackRequest, GetStackResponse> forStack(GetStackRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Stack.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forStack(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetStackRequest, GetStackResponse> forStack(BmcGenericWaiter waiter, GetStackRequest request, Stack.LifecycleState ... targetStates) {
        final HashSet<Stack.LifecycleState> targetStatesSet = new HashSet<Stack.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetStackRequest, GetStackResponse>(){

            @Override
            public GetStackResponse apply(GetStackRequest request) {
                return ResourceManagerWaiters.this.client.getStack(request);
            }
        }, (Predicate)new Predicate<GetStackResponse>(){

            @Override
            public boolean test(GetStackResponse response) {
                return targetStatesSet.contains((Object)response.getStack().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Stack.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, Template.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTemplate(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, Template.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(GetTemplateRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Template.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTemplate(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTemplateRequest, GetTemplateResponse> forTemplate(BmcGenericWaiter waiter, GetTemplateRequest request, Template.LifecycleState ... targetStates) {
        final HashSet<Template.LifecycleState> targetStatesSet = new HashSet<Template.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetTemplateRequest, GetTemplateResponse>(){

            @Override
            public GetTemplateResponse apply(GetTemplateRequest request) {
                return ResourceManagerWaiters.this.client.getTemplate(request);
            }
        }, (Predicate)new Predicate<GetTemplateResponse>(){

            @Override
            public boolean test(GetTemplateResponse response) {
                return targetStatesSet.contains((Object)response.getTemplate().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return ResourceManagerWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

