/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubusage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GetComputedUsageRequest
extends BmcRequest<Void> {
    private String computedUsageId;
    private String compartmentId;
    private List<String> fields;
    private String opcRequestId;
    private String xOneOriginRegion;

    public String getComputedUsageId() {
        return this.computedUsageId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getXOneOriginRegion() {
        return this.xOneOriginRegion;
    }

    public Builder toBuilder() {
        return new Builder().computedUsageId(this.computedUsageId).compartmentId(this.compartmentId).fields(this.fields).opcRequestId(this.opcRequestId).xOneOriginRegion(this.xOneOriginRegion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",computedUsageId=").append(String.valueOf(this.computedUsageId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",fields=").append(String.valueOf(this.fields));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",xOneOriginRegion=").append(String.valueOf(this.xOneOriginRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetComputedUsageRequest)) {
            return false;
        }
        GetComputedUsageRequest other = (GetComputedUsageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.computedUsageId, other.computedUsageId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.fields, other.fields) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.xOneOriginRegion, other.xOneOriginRegion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.computedUsageId == null ? 43 : this.computedUsageId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.fields == null ? 43 : this.fields.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.xOneOriginRegion == null ? 43 : this.xOneOriginRegion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetComputedUsageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String computedUsageId = null;
        private String compartmentId = null;
        private List<String> fields = null;
        private String opcRequestId = null;
        private String xOneOriginRegion = null;

        public Builder computedUsageId(String computedUsageId) {
            this.computedUsageId = computedUsageId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(String singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder xOneOriginRegion(String xOneOriginRegion) {
            this.xOneOriginRegion = xOneOriginRegion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetComputedUsageRequest o) {
            this.computedUsageId(o.getComputedUsageId());
            this.compartmentId(o.getCompartmentId());
            this.fields(o.getFields());
            this.opcRequestId(o.getOpcRequestId());
            this.xOneOriginRegion(o.getXOneOriginRegion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetComputedUsageRequest build() {
            GetComputedUsageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetComputedUsageRequest buildWithoutInvocationCallback() {
            GetComputedUsageRequest request = new GetComputedUsageRequest();
            request.computedUsageId = this.computedUsageId;
            request.compartmentId = this.compartmentId;
            request.fields = this.fields;
            request.opcRequestId = this.opcRequestId;
            request.xOneOriginRegion = this.xOneOriginRegion;
            return request;
        }
    }
}

