/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubsubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osubsubscription.model.Currency;
import com.oracle.bmc.osubsubscription.model.SubscribedServiceSummary;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SubscriptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="currency")
    private final Currency currency;
    @JsonProperty(value="serviceName")
    private final String serviceName;
    @JsonProperty(value="subscribedServices")
    private final List<SubscribedServiceSummary> subscribedServices;

    @Deprecated
    @ConstructorProperties(value={"status", "timeStart", "timeEnd", "currency", "serviceName", "subscribedServices"})
    public SubscriptionSummary(String status, Date timeStart, Date timeEnd, Currency currency, String serviceName, List<SubscribedServiceSummary> subscribedServices) {
        this.status = status;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.currency = currency;
        this.serviceName = serviceName;
        this.subscribedServices = subscribedServices;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getStatus() {
        return this.status;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<SubscribedServiceSummary> getSubscribedServices() {
        return this.subscribedServices;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf(this.status));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(", serviceName=").append(String.valueOf(this.serviceName));
        sb.append(", subscribedServices=").append(String.valueOf(this.subscribedServices));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionSummary)) {
            return false;
        }
        SubscriptionSummary other = (SubscriptionSummary)((Object)o);
        return Objects.equals(this.status, other.status) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals((Object)this.currency, (Object)other.currency) && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.subscribedServices, other.subscribedServices) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.serviceName == null ? 43 : this.serviceName.hashCode());
        result = result * 59 + (this.subscribedServices == null ? 43 : this.subscribedServices.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="currency")
        private Currency currency;
        @JsonProperty(value="serviceName")
        private String serviceName;
        @JsonProperty(value="subscribedServices")
        private List<SubscribedServiceSummary> subscribedServices;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.__explicitlySet__.add("serviceName");
            return this;
        }

        public Builder subscribedServices(List<SubscribedServiceSummary> subscribedServices) {
            this.subscribedServices = subscribedServices;
            this.__explicitlySet__.add("subscribedServices");
            return this;
        }

        public SubscriptionSummary build() {
            SubscriptionSummary model = new SubscriptionSummary(this.status, this.timeStart, this.timeEnd, this.currency, this.serviceName, this.subscribedServices);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SubscriptionSummary model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("serviceName")) {
                this.serviceName(model.getServiceName());
            }
            if (model.wasPropertyExplicitlySet("subscribedServices")) {
                this.subscribedServices(model.getSubscribedServices());
            }
            return this;
        }
    }
}

