/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osubsubscription.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osubsubscription.model.Currency;
import com.oracle.bmc.osubsubscription.model.Product;
import com.oracle.bmc.osubsubscription.model.RateCardTier;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RateCardSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="product")
    private final Product product;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="netUnitPrice")
    private final String netUnitPrice;
    @JsonProperty(value="discretionaryDiscountPercentage")
    private final String discretionaryDiscountPercentage;
    @JsonProperty(value="overagePrice")
    private final String overagePrice;
    @JsonProperty(value="isTier")
    private final Boolean isTier;
    @JsonProperty(value="currency")
    private final Currency currency;
    @JsonProperty(value="rateCardTiers")
    private final List<RateCardTier> rateCardTiers;

    @Deprecated
    @ConstructorProperties(value={"product", "timeStart", "timeEnd", "netUnitPrice", "discretionaryDiscountPercentage", "overagePrice", "isTier", "currency", "rateCardTiers"})
    public RateCardSummary(Product product, Date timeStart, Date timeEnd, String netUnitPrice, String discretionaryDiscountPercentage, String overagePrice, Boolean isTier, Currency currency, List<RateCardTier> rateCardTiers) {
        this.product = product;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.netUnitPrice = netUnitPrice;
        this.discretionaryDiscountPercentage = discretionaryDiscountPercentage;
        this.overagePrice = overagePrice;
        this.isTier = isTier;
        this.currency = currency;
        this.rateCardTiers = rateCardTiers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Product getProduct() {
        return this.product;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public String getNetUnitPrice() {
        return this.netUnitPrice;
    }

    public String getDiscretionaryDiscountPercentage() {
        return this.discretionaryDiscountPercentage;
    }

    public String getOveragePrice() {
        return this.overagePrice;
    }

    public Boolean getIsTier() {
        return this.isTier;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public List<RateCardTier> getRateCardTiers() {
        return this.rateCardTiers;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RateCardSummary(");
        sb.append("super=").append(super.toString());
        sb.append("product=").append(String.valueOf((Object)this.product));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", netUnitPrice=").append(String.valueOf(this.netUnitPrice));
        sb.append(", discretionaryDiscountPercentage=").append(String.valueOf(this.discretionaryDiscountPercentage));
        sb.append(", overagePrice=").append(String.valueOf(this.overagePrice));
        sb.append(", isTier=").append(String.valueOf(this.isTier));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(", rateCardTiers=").append(String.valueOf(this.rateCardTiers));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RateCardSummary)) {
            return false;
        }
        RateCardSummary other = (RateCardSummary)((Object)o);
        return Objects.equals((Object)this.product, (Object)other.product) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.netUnitPrice, other.netUnitPrice) && Objects.equals(this.discretionaryDiscountPercentage, other.discretionaryDiscountPercentage) && Objects.equals(this.overagePrice, other.overagePrice) && Objects.equals(this.isTier, other.isTier) && Objects.equals((Object)this.currency, (Object)other.currency) && Objects.equals(this.rateCardTiers, other.rateCardTiers) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.product == null ? 43 : this.product.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.netUnitPrice == null ? 43 : this.netUnitPrice.hashCode());
        result = result * 59 + (this.discretionaryDiscountPercentage == null ? 43 : this.discretionaryDiscountPercentage.hashCode());
        result = result * 59 + (this.overagePrice == null ? 43 : this.overagePrice.hashCode());
        result = result * 59 + (this.isTier == null ? 43 : this.isTier.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.rateCardTiers == null ? 43 : this.rateCardTiers.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="product")
        private Product product;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="netUnitPrice")
        private String netUnitPrice;
        @JsonProperty(value="discretionaryDiscountPercentage")
        private String discretionaryDiscountPercentage;
        @JsonProperty(value="overagePrice")
        private String overagePrice;
        @JsonProperty(value="isTier")
        private Boolean isTier;
        @JsonProperty(value="currency")
        private Currency currency;
        @JsonProperty(value="rateCardTiers")
        private List<RateCardTier> rateCardTiers;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder product(Product product) {
            this.product = product;
            this.__explicitlySet__.add("product");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder netUnitPrice(String netUnitPrice) {
            this.netUnitPrice = netUnitPrice;
            this.__explicitlySet__.add("netUnitPrice");
            return this;
        }

        public Builder discretionaryDiscountPercentage(String discretionaryDiscountPercentage) {
            this.discretionaryDiscountPercentage = discretionaryDiscountPercentage;
            this.__explicitlySet__.add("discretionaryDiscountPercentage");
            return this;
        }

        public Builder overagePrice(String overagePrice) {
            this.overagePrice = overagePrice;
            this.__explicitlySet__.add("overagePrice");
            return this;
        }

        public Builder isTier(Boolean isTier) {
            this.isTier = isTier;
            this.__explicitlySet__.add("isTier");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder rateCardTiers(List<RateCardTier> rateCardTiers) {
            this.rateCardTiers = rateCardTiers;
            this.__explicitlySet__.add("rateCardTiers");
            return this;
        }

        public RateCardSummary build() {
            RateCardSummary model = new RateCardSummary(this.product, this.timeStart, this.timeEnd, this.netUnitPrice, this.discretionaryDiscountPercentage, this.overagePrice, this.isTier, this.currency, this.rateCardTiers);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RateCardSummary model) {
            if (model.wasPropertyExplicitlySet("product")) {
                this.product(model.getProduct());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("netUnitPrice")) {
                this.netUnitPrice(model.getNetUnitPrice());
            }
            if (model.wasPropertyExplicitlySet("discretionaryDiscountPercentage")) {
                this.discretionaryDiscountPercentage(model.getDiscretionaryDiscountPercentage());
            }
            if (model.wasPropertyExplicitlySet("overagePrice")) {
                this.overagePrice(model.getOveragePrice());
            }
            if (model.wasPropertyExplicitlySet("isTier")) {
                this.isTier(model.getIsTier());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("rateCardTiers")) {
                this.rateCardTiers(model.getRateCardTiers());
            }
            return this;
        }
    }
}

