/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.responses;

import com.oracle.bmc.ospgateway.model.SubscriptionCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSubscriptionsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private Integer opcTotalItems;
    private SubscriptionCollection subscriptionCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public Integer getOpcTotalItems() {
        return this.opcTotalItems;
    }

    public SubscriptionCollection getSubscriptionCollection() {
        return this.subscriptionCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "opcTotalItems", "subscriptionCollection"})
    private ListSubscriptionsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, Integer opcTotalItems, SubscriptionCollection subscriptionCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcTotalItems = opcTotalItems;
        this.subscriptionCollection = subscriptionCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcTotalItems=").append(String.valueOf(this.opcTotalItems));
        sb.append(",subscriptionCollection=").append(String.valueOf((Object)this.subscriptionCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSubscriptionsResponse)) {
            return false;
        }
        ListSubscriptionsResponse other = (ListSubscriptionsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcTotalItems, other.opcTotalItems) && Objects.equals((Object)this.subscriptionCollection, (Object)other.subscriptionCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcTotalItems == null ? 43 : this.opcTotalItems.hashCode());
        result = result * 59 + (this.subscriptionCollection == null ? 43 : this.subscriptionCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListSubscriptionsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private Integer opcTotalItems;
        private SubscriptionCollection subscriptionCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcTotalItems(Integer opcTotalItems) {
            this.opcTotalItems = opcTotalItems;
            return this;
        }

        public Builder subscriptionCollection(SubscriptionCollection subscriptionCollection) {
            this.subscriptionCollection = subscriptionCollection;
            return this;
        }

        public Builder copy(ListSubscriptionsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcTotalItems(o.getOpcTotalItems());
            this.subscriptionCollection(o.getSubscriptionCollection());
            return this;
        }

        public ListSubscriptionsResponse build() {
            return new ListSubscriptionsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.opcTotalItems, this.subscriptionCollection);
        }
    }
}

