/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.ospgateway.model.AuthorizeSubscriptionPaymentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class AuthorizeSubscriptionPaymentRequest
extends BmcRequest<AuthorizeSubscriptionPaymentDetails> {
    private String ospHomeRegion;
    private String subscriptionId;
    private String compartmentId;
    private AuthorizeSubscriptionPaymentDetails authorizeSubscriptionPaymentDetails;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;

    public String getOspHomeRegion() {
        return this.ospHomeRegion;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public AuthorizeSubscriptionPaymentDetails getAuthorizeSubscriptionPaymentDetails() {
        return this.authorizeSubscriptionPaymentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public AuthorizeSubscriptionPaymentDetails getBody$() {
        return this.authorizeSubscriptionPaymentDetails;
    }

    public Builder toBuilder() {
        return new Builder().ospHomeRegion(this.ospHomeRegion).subscriptionId(this.subscriptionId).compartmentId(this.compartmentId).authorizeSubscriptionPaymentDetails(this.authorizeSubscriptionPaymentDetails).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",ospHomeRegion=").append(String.valueOf(this.ospHomeRegion));
        sb.append(",subscriptionId=").append(String.valueOf(this.subscriptionId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",authorizeSubscriptionPaymentDetails=").append(String.valueOf((Object)this.authorizeSubscriptionPaymentDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorizeSubscriptionPaymentRequest)) {
            return false;
        }
        AuthorizeSubscriptionPaymentRequest other = (AuthorizeSubscriptionPaymentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.ospHomeRegion, other.ospHomeRegion) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.authorizeSubscriptionPaymentDetails, (Object)other.authorizeSubscriptionPaymentDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ospHomeRegion == null ? 43 : this.ospHomeRegion.hashCode());
        result = result * 59 + (this.subscriptionId == null ? 43 : this.subscriptionId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.authorizeSubscriptionPaymentDetails == null ? 43 : this.authorizeSubscriptionPaymentDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AuthorizeSubscriptionPaymentRequest, AuthorizeSubscriptionPaymentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String ospHomeRegion = null;
        private String subscriptionId = null;
        private String compartmentId = null;
        private AuthorizeSubscriptionPaymentDetails authorizeSubscriptionPaymentDetails = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder ospHomeRegion(String ospHomeRegion) {
            this.ospHomeRegion = ospHomeRegion;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder authorizeSubscriptionPaymentDetails(AuthorizeSubscriptionPaymentDetails authorizeSubscriptionPaymentDetails) {
            this.authorizeSubscriptionPaymentDetails = authorizeSubscriptionPaymentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AuthorizeSubscriptionPaymentRequest o) {
            this.ospHomeRegion(o.getOspHomeRegion());
            this.subscriptionId(o.getSubscriptionId());
            this.compartmentId(o.getCompartmentId());
            this.authorizeSubscriptionPaymentDetails(o.getAuthorizeSubscriptionPaymentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AuthorizeSubscriptionPaymentRequest build() {
            AuthorizeSubscriptionPaymentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(AuthorizeSubscriptionPaymentDetails body) {
            this.authorizeSubscriptionPaymentDetails(body);
            return this;
        }

        public AuthorizeSubscriptionPaymentRequest buildWithoutInvocationCallback() {
            AuthorizeSubscriptionPaymentRequest request = new AuthorizeSubscriptionPaymentRequest();
            request.ospHomeRegion = this.ospHomeRegion;
            request.subscriptionId = this.subscriptionId;
            request.compartmentId = this.compartmentId;
            request.authorizeSubscriptionPaymentDetails = this.authorizeSubscriptionPaymentDetails;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

