/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MerchantDefinedData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="promoType")
    private final String promoType;
    @JsonProperty(value="cloudAccountName")
    private final String cloudAccountName;

    @Deprecated
    @ConstructorProperties(value={"promoType", "cloudAccountName"})
    public MerchantDefinedData(String promoType, String cloudAccountName) {
        this.promoType = promoType;
        this.cloudAccountName = cloudAccountName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPromoType() {
        return this.promoType;
    }

    public String getCloudAccountName() {
        return this.cloudAccountName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MerchantDefinedData(");
        sb.append("super=").append(super.toString());
        sb.append("promoType=").append(String.valueOf(this.promoType));
        sb.append(", cloudAccountName=").append(String.valueOf(this.cloudAccountName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerchantDefinedData)) {
            return false;
        }
        MerchantDefinedData other = (MerchantDefinedData)((Object)o);
        return Objects.equals(this.promoType, other.promoType) && Objects.equals(this.cloudAccountName, other.cloudAccountName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.promoType == null ? 43 : this.promoType.hashCode());
        result = result * 59 + (this.cloudAccountName == null ? 43 : this.cloudAccountName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="promoType")
        private String promoType;
        @JsonProperty(value="cloudAccountName")
        private String cloudAccountName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder promoType(String promoType) {
            this.promoType = promoType;
            this.__explicitlySet__.add("promoType");
            return this;
        }

        public Builder cloudAccountName(String cloudAccountName) {
            this.cloudAccountName = cloudAccountName;
            this.__explicitlySet__.add("cloudAccountName");
            return this;
        }

        public MerchantDefinedData build() {
            MerchantDefinedData model = new MerchantDefinedData(this.promoType, this.cloudAccountName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MerchantDefinedData model) {
            if (model.wasPropertyExplicitlySet("promoType")) {
                this.promoType(model.getPromoType());
            }
            if (model.wasPropertyExplicitlySet("cloudAccountName")) {
                this.cloudAccountName(model.getCloudAccountName());
            }
            return this;
        }
    }
}

