/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.ospgateway.model.BillToAddress;
import com.oracle.bmc.ospgateway.model.Currency;
import com.oracle.bmc.ospgateway.model.PaymentDetail;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Invoice
extends ExplicitlySetBmcModel {
    @JsonProperty(value="invoiceId")
    private final String invoiceId;
    @JsonProperty(value="invoiceNumber")
    private final String invoiceNumber;
    @JsonProperty(value="internalInvoiceId")
    private final String internalInvoiceId;
    @JsonProperty(value="isCreditCardPayable")
    private final Boolean isCreditCardPayable;
    @JsonProperty(value="timeInvoice")
    private final Date timeInvoice;
    @JsonProperty(value="tax")
    private final BigDecimal tax;
    @JsonProperty(value="invoiceAmount")
    private final BigDecimal invoiceAmount;
    @JsonProperty(value="invoiceAmountDue")
    private final BigDecimal invoiceAmountDue;
    @JsonProperty(value="invoiceAmountCredited")
    private final BigDecimal invoiceAmountCredited;
    @JsonProperty(value="invoiceAmountAdjusted")
    private final BigDecimal invoiceAmountAdjusted;
    @JsonProperty(value="invoiceAmountApplied")
    private final BigDecimal invoiceAmountApplied;
    @JsonProperty(value="currency")
    private final Currency currency;
    @JsonProperty(value="invoiceType")
    private final InvoiceType invoiceType;
    @JsonProperty(value="timeInvoiceDue")
    private final Date timeInvoiceDue;
    @JsonProperty(value="invoiceRefNumber")
    private final String invoiceRefNumber;
    @JsonProperty(value="invoicePoNumber")
    private final String invoicePoNumber;
    @JsonProperty(value="invoiceStatus")
    private final InvoiceStatus invoiceStatus;
    @JsonProperty(value="preferredEmail")
    private final String preferredEmail;
    @JsonProperty(value="isPdfEmailAvailable")
    private final Boolean isPdfEmailAvailable;
    @JsonProperty(value="isDisplayDownloadPdf")
    private final Boolean isDisplayDownloadPdf;
    @JsonProperty(value="isPayable")
    private final Boolean isPayable;
    @JsonProperty(value="paymentTerms")
    private final String paymentTerms;
    @JsonProperty(value="lastPaymentDetail")
    private final PaymentDetail lastPaymentDetail;
    @JsonProperty(value="billToAddress")
    private final BillToAddress billToAddress;
    @JsonProperty(value="subscriptionIds")
    private final List<String> subscriptionIds;

    @Deprecated
    @ConstructorProperties(value={"invoiceId", "invoiceNumber", "internalInvoiceId", "isCreditCardPayable", "timeInvoice", "tax", "invoiceAmount", "invoiceAmountDue", "invoiceAmountCredited", "invoiceAmountAdjusted", "invoiceAmountApplied", "currency", "invoiceType", "timeInvoiceDue", "invoiceRefNumber", "invoicePoNumber", "invoiceStatus", "preferredEmail", "isPdfEmailAvailable", "isDisplayDownloadPdf", "isPayable", "paymentTerms", "lastPaymentDetail", "billToAddress", "subscriptionIds"})
    public Invoice(String invoiceId, String invoiceNumber, String internalInvoiceId, Boolean isCreditCardPayable, Date timeInvoice, BigDecimal tax, BigDecimal invoiceAmount, BigDecimal invoiceAmountDue, BigDecimal invoiceAmountCredited, BigDecimal invoiceAmountAdjusted, BigDecimal invoiceAmountApplied, Currency currency, InvoiceType invoiceType, Date timeInvoiceDue, String invoiceRefNumber, String invoicePoNumber, InvoiceStatus invoiceStatus, String preferredEmail, Boolean isPdfEmailAvailable, Boolean isDisplayDownloadPdf, Boolean isPayable, String paymentTerms, PaymentDetail lastPaymentDetail, BillToAddress billToAddress, List<String> subscriptionIds) {
        this.invoiceId = invoiceId;
        this.invoiceNumber = invoiceNumber;
        this.internalInvoiceId = internalInvoiceId;
        this.isCreditCardPayable = isCreditCardPayable;
        this.timeInvoice = timeInvoice;
        this.tax = tax;
        this.invoiceAmount = invoiceAmount;
        this.invoiceAmountDue = invoiceAmountDue;
        this.invoiceAmountCredited = invoiceAmountCredited;
        this.invoiceAmountAdjusted = invoiceAmountAdjusted;
        this.invoiceAmountApplied = invoiceAmountApplied;
        this.currency = currency;
        this.invoiceType = invoiceType;
        this.timeInvoiceDue = timeInvoiceDue;
        this.invoiceRefNumber = invoiceRefNumber;
        this.invoicePoNumber = invoicePoNumber;
        this.invoiceStatus = invoiceStatus;
        this.preferredEmail = preferredEmail;
        this.isPdfEmailAvailable = isPdfEmailAvailable;
        this.isDisplayDownloadPdf = isDisplayDownloadPdf;
        this.isPayable = isPayable;
        this.paymentTerms = paymentTerms;
        this.lastPaymentDetail = lastPaymentDetail;
        this.billToAddress = billToAddress;
        this.subscriptionIds = subscriptionIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public String getInternalInvoiceId() {
        return this.internalInvoiceId;
    }

    public Boolean getIsCreditCardPayable() {
        return this.isCreditCardPayable;
    }

    public Date getTimeInvoice() {
        return this.timeInvoice;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public BigDecimal getInvoiceAmount() {
        return this.invoiceAmount;
    }

    public BigDecimal getInvoiceAmountDue() {
        return this.invoiceAmountDue;
    }

    public BigDecimal getInvoiceAmountCredited() {
        return this.invoiceAmountCredited;
    }

    public BigDecimal getInvoiceAmountAdjusted() {
        return this.invoiceAmountAdjusted;
    }

    public BigDecimal getInvoiceAmountApplied() {
        return this.invoiceAmountApplied;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public InvoiceType getInvoiceType() {
        return this.invoiceType;
    }

    public Date getTimeInvoiceDue() {
        return this.timeInvoiceDue;
    }

    public String getInvoiceRefNumber() {
        return this.invoiceRefNumber;
    }

    public String getInvoicePoNumber() {
        return this.invoicePoNumber;
    }

    public InvoiceStatus getInvoiceStatus() {
        return this.invoiceStatus;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public Boolean getIsPdfEmailAvailable() {
        return this.isPdfEmailAvailable;
    }

    public Boolean getIsDisplayDownloadPdf() {
        return this.isDisplayDownloadPdf;
    }

    public Boolean getIsPayable() {
        return this.isPayable;
    }

    public String getPaymentTerms() {
        return this.paymentTerms;
    }

    public PaymentDetail getLastPaymentDetail() {
        return this.lastPaymentDetail;
    }

    public BillToAddress getBillToAddress() {
        return this.billToAddress;
    }

    public List<String> getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Invoice(");
        sb.append("super=").append(super.toString());
        sb.append("invoiceId=").append(String.valueOf(this.invoiceId));
        sb.append(", invoiceNumber=").append(String.valueOf(this.invoiceNumber));
        sb.append(", internalInvoiceId=").append(String.valueOf(this.internalInvoiceId));
        sb.append(", isCreditCardPayable=").append(String.valueOf(this.isCreditCardPayable));
        sb.append(", timeInvoice=").append(String.valueOf(this.timeInvoice));
        sb.append(", tax=").append(String.valueOf(this.tax));
        sb.append(", invoiceAmount=").append(String.valueOf(this.invoiceAmount));
        sb.append(", invoiceAmountDue=").append(String.valueOf(this.invoiceAmountDue));
        sb.append(", invoiceAmountCredited=").append(String.valueOf(this.invoiceAmountCredited));
        sb.append(", invoiceAmountAdjusted=").append(String.valueOf(this.invoiceAmountAdjusted));
        sb.append(", invoiceAmountApplied=").append(String.valueOf(this.invoiceAmountApplied));
        sb.append(", currency=").append(String.valueOf((Object)this.currency));
        sb.append(", invoiceType=").append(String.valueOf((Object)this.invoiceType));
        sb.append(", timeInvoiceDue=").append(String.valueOf(this.timeInvoiceDue));
        sb.append(", invoiceRefNumber=").append(String.valueOf(this.invoiceRefNumber));
        sb.append(", invoicePoNumber=").append(String.valueOf(this.invoicePoNumber));
        sb.append(", invoiceStatus=").append(String.valueOf((Object)this.invoiceStatus));
        sb.append(", preferredEmail=").append(String.valueOf(this.preferredEmail));
        sb.append(", isPdfEmailAvailable=").append(String.valueOf(this.isPdfEmailAvailable));
        sb.append(", isDisplayDownloadPdf=").append(String.valueOf(this.isDisplayDownloadPdf));
        sb.append(", isPayable=").append(String.valueOf(this.isPayable));
        sb.append(", paymentTerms=").append(String.valueOf(this.paymentTerms));
        sb.append(", lastPaymentDetail=").append(String.valueOf((Object)this.lastPaymentDetail));
        sb.append(", billToAddress=").append(String.valueOf((Object)this.billToAddress));
        sb.append(", subscriptionIds=").append(String.valueOf(this.subscriptionIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)((Object)o);
        return Objects.equals(this.invoiceId, other.invoiceId) && Objects.equals(this.invoiceNumber, other.invoiceNumber) && Objects.equals(this.internalInvoiceId, other.internalInvoiceId) && Objects.equals(this.isCreditCardPayable, other.isCreditCardPayable) && Objects.equals(this.timeInvoice, other.timeInvoice) && Objects.equals(this.tax, other.tax) && Objects.equals(this.invoiceAmount, other.invoiceAmount) && Objects.equals(this.invoiceAmountDue, other.invoiceAmountDue) && Objects.equals(this.invoiceAmountCredited, other.invoiceAmountCredited) && Objects.equals(this.invoiceAmountAdjusted, other.invoiceAmountAdjusted) && Objects.equals(this.invoiceAmountApplied, other.invoiceAmountApplied) && Objects.equals((Object)this.currency, (Object)other.currency) && Objects.equals((Object)this.invoiceType, (Object)other.invoiceType) && Objects.equals(this.timeInvoiceDue, other.timeInvoiceDue) && Objects.equals(this.invoiceRefNumber, other.invoiceRefNumber) && Objects.equals(this.invoicePoNumber, other.invoicePoNumber) && Objects.equals((Object)this.invoiceStatus, (Object)other.invoiceStatus) && Objects.equals(this.preferredEmail, other.preferredEmail) && Objects.equals(this.isPdfEmailAvailable, other.isPdfEmailAvailable) && Objects.equals(this.isDisplayDownloadPdf, other.isDisplayDownloadPdf) && Objects.equals(this.isPayable, other.isPayable) && Objects.equals(this.paymentTerms, other.paymentTerms) && Objects.equals((Object)this.lastPaymentDetail, (Object)other.lastPaymentDetail) && Objects.equals((Object)this.billToAddress, (Object)other.billToAddress) && Objects.equals(this.subscriptionIds, other.subscriptionIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.invoiceId == null ? 43 : this.invoiceId.hashCode());
        result = result * 59 + (this.invoiceNumber == null ? 43 : this.invoiceNumber.hashCode());
        result = result * 59 + (this.internalInvoiceId == null ? 43 : this.internalInvoiceId.hashCode());
        result = result * 59 + (this.isCreditCardPayable == null ? 43 : this.isCreditCardPayable.hashCode());
        result = result * 59 + (this.timeInvoice == null ? 43 : this.timeInvoice.hashCode());
        result = result * 59 + (this.tax == null ? 43 : this.tax.hashCode());
        result = result * 59 + (this.invoiceAmount == null ? 43 : this.invoiceAmount.hashCode());
        result = result * 59 + (this.invoiceAmountDue == null ? 43 : this.invoiceAmountDue.hashCode());
        result = result * 59 + (this.invoiceAmountCredited == null ? 43 : this.invoiceAmountCredited.hashCode());
        result = result * 59 + (this.invoiceAmountAdjusted == null ? 43 : this.invoiceAmountAdjusted.hashCode());
        result = result * 59 + (this.invoiceAmountApplied == null ? 43 : this.invoiceAmountApplied.hashCode());
        result = result * 59 + (this.currency == null ? 43 : this.currency.hashCode());
        result = result * 59 + (this.invoiceType == null ? 43 : this.invoiceType.hashCode());
        result = result * 59 + (this.timeInvoiceDue == null ? 43 : this.timeInvoiceDue.hashCode());
        result = result * 59 + (this.invoiceRefNumber == null ? 43 : this.invoiceRefNumber.hashCode());
        result = result * 59 + (this.invoicePoNumber == null ? 43 : this.invoicePoNumber.hashCode());
        result = result * 59 + (this.invoiceStatus == null ? 43 : this.invoiceStatus.hashCode());
        result = result * 59 + (this.preferredEmail == null ? 43 : this.preferredEmail.hashCode());
        result = result * 59 + (this.isPdfEmailAvailable == null ? 43 : this.isPdfEmailAvailable.hashCode());
        result = result * 59 + (this.isDisplayDownloadPdf == null ? 43 : this.isDisplayDownloadPdf.hashCode());
        result = result * 59 + (this.isPayable == null ? 43 : this.isPayable.hashCode());
        result = result * 59 + (this.paymentTerms == null ? 43 : this.paymentTerms.hashCode());
        result = result * 59 + (this.lastPaymentDetail == null ? 43 : this.lastPaymentDetail.hashCode());
        result = result * 59 + (this.billToAddress == null ? 43 : this.billToAddress.hashCode());
        result = result * 59 + (this.subscriptionIds == null ? 43 : this.subscriptionIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum InvoiceStatus implements BmcEnum
    {
        Open("OPEN"),
        PastDue("PAST_DUE"),
        PaymentSubmitted("PAYMENT_SUBMITTED"),
        Closed("CLOSED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InvoiceStatus> map;

        private InvoiceStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InvoiceStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InvoiceStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InvoiceStatus.class);
            map = new HashMap<String, InvoiceStatus>();
            for (InvoiceStatus v : InvoiceStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum InvoiceType implements BmcEnum
    {
        Hardware("HARDWARE"),
        Subscription("SUBSCRIPTION"),
        Support("SUPPORT"),
        License("LICENSE"),
        Education("EDUCATION"),
        Consulting("CONSULTING"),
        Service("SERVICE"),
        Usage("USAGE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, InvoiceType> map;

        private InvoiceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static InvoiceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'InvoiceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(InvoiceType.class);
            map = new HashMap<String, InvoiceType>();
            for (InvoiceType v : InvoiceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="invoiceId")
        private String invoiceId;
        @JsonProperty(value="invoiceNumber")
        private String invoiceNumber;
        @JsonProperty(value="internalInvoiceId")
        private String internalInvoiceId;
        @JsonProperty(value="isCreditCardPayable")
        private Boolean isCreditCardPayable;
        @JsonProperty(value="timeInvoice")
        private Date timeInvoice;
        @JsonProperty(value="tax")
        private BigDecimal tax;
        @JsonProperty(value="invoiceAmount")
        private BigDecimal invoiceAmount;
        @JsonProperty(value="invoiceAmountDue")
        private BigDecimal invoiceAmountDue;
        @JsonProperty(value="invoiceAmountCredited")
        private BigDecimal invoiceAmountCredited;
        @JsonProperty(value="invoiceAmountAdjusted")
        private BigDecimal invoiceAmountAdjusted;
        @JsonProperty(value="invoiceAmountApplied")
        private BigDecimal invoiceAmountApplied;
        @JsonProperty(value="currency")
        private Currency currency;
        @JsonProperty(value="invoiceType")
        private InvoiceType invoiceType;
        @JsonProperty(value="timeInvoiceDue")
        private Date timeInvoiceDue;
        @JsonProperty(value="invoiceRefNumber")
        private String invoiceRefNumber;
        @JsonProperty(value="invoicePoNumber")
        private String invoicePoNumber;
        @JsonProperty(value="invoiceStatus")
        private InvoiceStatus invoiceStatus;
        @JsonProperty(value="preferredEmail")
        private String preferredEmail;
        @JsonProperty(value="isPdfEmailAvailable")
        private Boolean isPdfEmailAvailable;
        @JsonProperty(value="isDisplayDownloadPdf")
        private Boolean isDisplayDownloadPdf;
        @JsonProperty(value="isPayable")
        private Boolean isPayable;
        @JsonProperty(value="paymentTerms")
        private String paymentTerms;
        @JsonProperty(value="lastPaymentDetail")
        private PaymentDetail lastPaymentDetail;
        @JsonProperty(value="billToAddress")
        private BillToAddress billToAddress;
        @JsonProperty(value="subscriptionIds")
        private List<String> subscriptionIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            this.__explicitlySet__.add("invoiceId");
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
            this.__explicitlySet__.add("invoiceNumber");
            return this;
        }

        public Builder internalInvoiceId(String internalInvoiceId) {
            this.internalInvoiceId = internalInvoiceId;
            this.__explicitlySet__.add("internalInvoiceId");
            return this;
        }

        public Builder isCreditCardPayable(Boolean isCreditCardPayable) {
            this.isCreditCardPayable = isCreditCardPayable;
            this.__explicitlySet__.add("isCreditCardPayable");
            return this;
        }

        public Builder timeInvoice(Date timeInvoice) {
            this.timeInvoice = timeInvoice;
            this.__explicitlySet__.add("timeInvoice");
            return this;
        }

        public Builder tax(BigDecimal tax) {
            this.tax = tax;
            this.__explicitlySet__.add("tax");
            return this;
        }

        public Builder invoiceAmount(BigDecimal invoiceAmount) {
            this.invoiceAmount = invoiceAmount;
            this.__explicitlySet__.add("invoiceAmount");
            return this;
        }

        public Builder invoiceAmountDue(BigDecimal invoiceAmountDue) {
            this.invoiceAmountDue = invoiceAmountDue;
            this.__explicitlySet__.add("invoiceAmountDue");
            return this;
        }

        public Builder invoiceAmountCredited(BigDecimal invoiceAmountCredited) {
            this.invoiceAmountCredited = invoiceAmountCredited;
            this.__explicitlySet__.add("invoiceAmountCredited");
            return this;
        }

        public Builder invoiceAmountAdjusted(BigDecimal invoiceAmountAdjusted) {
            this.invoiceAmountAdjusted = invoiceAmountAdjusted;
            this.__explicitlySet__.add("invoiceAmountAdjusted");
            return this;
        }

        public Builder invoiceAmountApplied(BigDecimal invoiceAmountApplied) {
            this.invoiceAmountApplied = invoiceAmountApplied;
            this.__explicitlySet__.add("invoiceAmountApplied");
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            this.__explicitlySet__.add("currency");
            return this;
        }

        public Builder invoiceType(InvoiceType invoiceType) {
            this.invoiceType = invoiceType;
            this.__explicitlySet__.add("invoiceType");
            return this;
        }

        public Builder timeInvoiceDue(Date timeInvoiceDue) {
            this.timeInvoiceDue = timeInvoiceDue;
            this.__explicitlySet__.add("timeInvoiceDue");
            return this;
        }

        public Builder invoiceRefNumber(String invoiceRefNumber) {
            this.invoiceRefNumber = invoiceRefNumber;
            this.__explicitlySet__.add("invoiceRefNumber");
            return this;
        }

        public Builder invoicePoNumber(String invoicePoNumber) {
            this.invoicePoNumber = invoicePoNumber;
            this.__explicitlySet__.add("invoicePoNumber");
            return this;
        }

        public Builder invoiceStatus(InvoiceStatus invoiceStatus) {
            this.invoiceStatus = invoiceStatus;
            this.__explicitlySet__.add("invoiceStatus");
            return this;
        }

        public Builder preferredEmail(String preferredEmail) {
            this.preferredEmail = preferredEmail;
            this.__explicitlySet__.add("preferredEmail");
            return this;
        }

        public Builder isPdfEmailAvailable(Boolean isPdfEmailAvailable) {
            this.isPdfEmailAvailable = isPdfEmailAvailable;
            this.__explicitlySet__.add("isPdfEmailAvailable");
            return this;
        }

        public Builder isDisplayDownloadPdf(Boolean isDisplayDownloadPdf) {
            this.isDisplayDownloadPdf = isDisplayDownloadPdf;
            this.__explicitlySet__.add("isDisplayDownloadPdf");
            return this;
        }

        public Builder isPayable(Boolean isPayable) {
            this.isPayable = isPayable;
            this.__explicitlySet__.add("isPayable");
            return this;
        }

        public Builder paymentTerms(String paymentTerms) {
            this.paymentTerms = paymentTerms;
            this.__explicitlySet__.add("paymentTerms");
            return this;
        }

        public Builder lastPaymentDetail(PaymentDetail lastPaymentDetail) {
            this.lastPaymentDetail = lastPaymentDetail;
            this.__explicitlySet__.add("lastPaymentDetail");
            return this;
        }

        public Builder billToAddress(BillToAddress billToAddress) {
            this.billToAddress = billToAddress;
            this.__explicitlySet__.add("billToAddress");
            return this;
        }

        public Builder subscriptionIds(List<String> subscriptionIds) {
            this.subscriptionIds = subscriptionIds;
            this.__explicitlySet__.add("subscriptionIds");
            return this;
        }

        public Invoice build() {
            Invoice model = new Invoice(this.invoiceId, this.invoiceNumber, this.internalInvoiceId, this.isCreditCardPayable, this.timeInvoice, this.tax, this.invoiceAmount, this.invoiceAmountDue, this.invoiceAmountCredited, this.invoiceAmountAdjusted, this.invoiceAmountApplied, this.currency, this.invoiceType, this.timeInvoiceDue, this.invoiceRefNumber, this.invoicePoNumber, this.invoiceStatus, this.preferredEmail, this.isPdfEmailAvailable, this.isDisplayDownloadPdf, this.isPayable, this.paymentTerms, this.lastPaymentDetail, this.billToAddress, this.subscriptionIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Invoice model) {
            if (model.wasPropertyExplicitlySet("invoiceId")) {
                this.invoiceId(model.getInvoiceId());
            }
            if (model.wasPropertyExplicitlySet("invoiceNumber")) {
                this.invoiceNumber(model.getInvoiceNumber());
            }
            if (model.wasPropertyExplicitlySet("internalInvoiceId")) {
                this.internalInvoiceId(model.getInternalInvoiceId());
            }
            if (model.wasPropertyExplicitlySet("isCreditCardPayable")) {
                this.isCreditCardPayable(model.getIsCreditCardPayable());
            }
            if (model.wasPropertyExplicitlySet("timeInvoice")) {
                this.timeInvoice(model.getTimeInvoice());
            }
            if (model.wasPropertyExplicitlySet("tax")) {
                this.tax(model.getTax());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmount")) {
                this.invoiceAmount(model.getInvoiceAmount());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountDue")) {
                this.invoiceAmountDue(model.getInvoiceAmountDue());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountCredited")) {
                this.invoiceAmountCredited(model.getInvoiceAmountCredited());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountAdjusted")) {
                this.invoiceAmountAdjusted(model.getInvoiceAmountAdjusted());
            }
            if (model.wasPropertyExplicitlySet("invoiceAmountApplied")) {
                this.invoiceAmountApplied(model.getInvoiceAmountApplied());
            }
            if (model.wasPropertyExplicitlySet("currency")) {
                this.currency(model.getCurrency());
            }
            if (model.wasPropertyExplicitlySet("invoiceType")) {
                this.invoiceType(model.getInvoiceType());
            }
            if (model.wasPropertyExplicitlySet("timeInvoiceDue")) {
                this.timeInvoiceDue(model.getTimeInvoiceDue());
            }
            if (model.wasPropertyExplicitlySet("invoiceRefNumber")) {
                this.invoiceRefNumber(model.getInvoiceRefNumber());
            }
            if (model.wasPropertyExplicitlySet("invoicePoNumber")) {
                this.invoicePoNumber(model.getInvoicePoNumber());
            }
            if (model.wasPropertyExplicitlySet("invoiceStatus")) {
                this.invoiceStatus(model.getInvoiceStatus());
            }
            if (model.wasPropertyExplicitlySet("preferredEmail")) {
                this.preferredEmail(model.getPreferredEmail());
            }
            if (model.wasPropertyExplicitlySet("isPdfEmailAvailable")) {
                this.isPdfEmailAvailable(model.getIsPdfEmailAvailable());
            }
            if (model.wasPropertyExplicitlySet("isDisplayDownloadPdf")) {
                this.isDisplayDownloadPdf(model.getIsDisplayDownloadPdf());
            }
            if (model.wasPropertyExplicitlySet("isPayable")) {
                this.isPayable(model.getIsPayable());
            }
            if (model.wasPropertyExplicitlySet("paymentTerms")) {
                this.paymentTerms(model.getPaymentTerms());
            }
            if (model.wasPropertyExplicitlySet("lastPaymentDetail")) {
                this.lastPaymentDetail(model.getLastPaymentDetail());
            }
            if (model.wasPropertyExplicitlySet("billToAddress")) {
                this.billToAddress(model.getBillToAddress());
            }
            if (model.wasPropertyExplicitlySet("subscriptionIds")) {
                this.subscriptionIds(model.getSubscriptionIds());
            }
            return this;
        }
    }
}

