/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ospgateway.model.CreditCardType;
import com.oracle.bmc.ospgateway.model.PaymentOption;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="paymentMethod")
@JsonFilter(value="explicitlySetFilter")
public final class CreditCardPaymentOption
extends PaymentOption {
    @JsonProperty(value="creditCardType")
    private final CreditCardType creditCardType;
    @JsonProperty(value="lastDigits")
    private final String lastDigits;
    @JsonProperty(value="nameOnCard")
    private final String nameOnCard;
    @JsonProperty(value="timeExpiration")
    private final Date timeExpiration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreditCardPaymentOption(String walletInstrumentId, String walletTransactionId, CreditCardType creditCardType, String lastDigits, String nameOnCard, Date timeExpiration) {
        super(walletInstrumentId, walletTransactionId);
        this.creditCardType = creditCardType;
        this.lastDigits = lastDigits;
        this.nameOnCard = nameOnCard;
        this.timeExpiration = timeExpiration;
    }

    public CreditCardType getCreditCardType() {
        return this.creditCardType;
    }

    public String getLastDigits() {
        return this.lastDigits;
    }

    public String getNameOnCard() {
        return this.nameOnCard;
    }

    public Date getTimeExpiration() {
        return this.timeExpiration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreditCardPaymentOption(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", creditCardType=").append(String.valueOf((Object)this.creditCardType));
        sb.append(", lastDigits=").append(String.valueOf(this.lastDigits));
        sb.append(", nameOnCard=").append(String.valueOf(this.nameOnCard));
        sb.append(", timeExpiration=").append(String.valueOf(this.timeExpiration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreditCardPaymentOption)) {
            return false;
        }
        CreditCardPaymentOption other = (CreditCardPaymentOption)((Object)o);
        return Objects.equals((Object)this.creditCardType, (Object)other.creditCardType) && Objects.equals(this.lastDigits, other.lastDigits) && Objects.equals(this.nameOnCard, other.nameOnCard) && Objects.equals(this.timeExpiration, other.timeExpiration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.creditCardType == null ? 43 : this.creditCardType.hashCode());
        result = result * 59 + (this.lastDigits == null ? 43 : this.lastDigits.hashCode());
        result = result * 59 + (this.nameOnCard == null ? 43 : this.nameOnCard.hashCode());
        result = result * 59 + (this.timeExpiration == null ? 43 : this.timeExpiration.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="walletInstrumentId")
        private String walletInstrumentId;
        @JsonProperty(value="walletTransactionId")
        private String walletTransactionId;
        @JsonProperty(value="creditCardType")
        private CreditCardType creditCardType;
        @JsonProperty(value="lastDigits")
        private String lastDigits;
        @JsonProperty(value="nameOnCard")
        private String nameOnCard;
        @JsonProperty(value="timeExpiration")
        private Date timeExpiration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder walletInstrumentId(String walletInstrumentId) {
            this.walletInstrumentId = walletInstrumentId;
            this.__explicitlySet__.add("walletInstrumentId");
            return this;
        }

        public Builder walletTransactionId(String walletTransactionId) {
            this.walletTransactionId = walletTransactionId;
            this.__explicitlySet__.add("walletTransactionId");
            return this;
        }

        public Builder creditCardType(CreditCardType creditCardType) {
            this.creditCardType = creditCardType;
            this.__explicitlySet__.add("creditCardType");
            return this;
        }

        public Builder lastDigits(String lastDigits) {
            this.lastDigits = lastDigits;
            this.__explicitlySet__.add("lastDigits");
            return this;
        }

        public Builder nameOnCard(String nameOnCard) {
            this.nameOnCard = nameOnCard;
            this.__explicitlySet__.add("nameOnCard");
            return this;
        }

        public Builder timeExpiration(Date timeExpiration) {
            this.timeExpiration = timeExpiration;
            this.__explicitlySet__.add("timeExpiration");
            return this;
        }

        public CreditCardPaymentOption build() {
            CreditCardPaymentOption model = new CreditCardPaymentOption(this.walletInstrumentId, this.walletTransactionId, this.creditCardType, this.lastDigits, this.nameOnCard, this.timeExpiration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreditCardPaymentOption model) {
            if (model.wasPropertyExplicitlySet("walletInstrumentId")) {
                this.walletInstrumentId(model.getWalletInstrumentId());
            }
            if (model.wasPropertyExplicitlySet("walletTransactionId")) {
                this.walletTransactionId(model.getWalletTransactionId());
            }
            if (model.wasPropertyExplicitlySet("creditCardType")) {
                this.creditCardType(model.getCreditCardType());
            }
            if (model.wasPropertyExplicitlySet("lastDigits")) {
                this.lastDigits(model.getLastDigits());
            }
            if (model.wasPropertyExplicitlySet("nameOnCard")) {
                this.nameOnCard(model.getNameOnCard());
            }
            if (model.wasPropertyExplicitlySet("timeExpiration")) {
                this.timeExpiration(model.getTimeExpiration());
            }
            return this;
        }
    }
}

