/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Country
extends ExplicitlySetBmcModel {
    @JsonProperty(value="countryId")
    private final BigDecimal countryId;
    @JsonProperty(value="countryCode")
    private final String countryCode;
    @JsonProperty(value="countryName")
    private final String countryName;
    @JsonProperty(value="languageId")
    private final BigDecimal languageId;
    @JsonProperty(value="ascii3CountryCode")
    private final String ascii3CountryCode;

    @Deprecated
    @ConstructorProperties(value={"countryId", "countryCode", "countryName", "languageId", "ascii3CountryCode"})
    public Country(BigDecimal countryId, String countryCode, String countryName, BigDecimal languageId, String ascii3CountryCode) {
        this.countryId = countryId;
        this.countryCode = countryCode;
        this.countryName = countryName;
        this.languageId = languageId;
        this.ascii3CountryCode = ascii3CountryCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BigDecimal getCountryId() {
        return this.countryId;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public BigDecimal getLanguageId() {
        return this.languageId;
    }

    public String getAscii3CountryCode() {
        return this.ascii3CountryCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Country(");
        sb.append("super=").append(super.toString());
        sb.append("countryId=").append(String.valueOf(this.countryId));
        sb.append(", countryCode=").append(String.valueOf(this.countryCode));
        sb.append(", countryName=").append(String.valueOf(this.countryName));
        sb.append(", languageId=").append(String.valueOf(this.languageId));
        sb.append(", ascii3CountryCode=").append(String.valueOf(this.ascii3CountryCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Country)) {
            return false;
        }
        Country other = (Country)((Object)o);
        return Objects.equals(this.countryId, other.countryId) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.countryName, other.countryName) && Objects.equals(this.languageId, other.languageId) && Objects.equals(this.ascii3CountryCode, other.ascii3CountryCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.countryId == null ? 43 : this.countryId.hashCode());
        result = result * 59 + (this.countryCode == null ? 43 : this.countryCode.hashCode());
        result = result * 59 + (this.countryName == null ? 43 : this.countryName.hashCode());
        result = result * 59 + (this.languageId == null ? 43 : this.languageId.hashCode());
        result = result * 59 + (this.ascii3CountryCode == null ? 43 : this.ascii3CountryCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="countryId")
        private BigDecimal countryId;
        @JsonProperty(value="countryCode")
        private String countryCode;
        @JsonProperty(value="countryName")
        private String countryName;
        @JsonProperty(value="languageId")
        private BigDecimal languageId;
        @JsonProperty(value="ascii3CountryCode")
        private String ascii3CountryCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder countryId(BigDecimal countryId) {
            this.countryId = countryId;
            this.__explicitlySet__.add("countryId");
            return this;
        }

        public Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            this.__explicitlySet__.add("countryCode");
            return this;
        }

        public Builder countryName(String countryName) {
            this.countryName = countryName;
            this.__explicitlySet__.add("countryName");
            return this;
        }

        public Builder languageId(BigDecimal languageId) {
            this.languageId = languageId;
            this.__explicitlySet__.add("languageId");
            return this;
        }

        public Builder ascii3CountryCode(String ascii3CountryCode) {
            this.ascii3CountryCode = ascii3CountryCode;
            this.__explicitlySet__.add("ascii3CountryCode");
            return this;
        }

        public Country build() {
            Country model = new Country(this.countryId, this.countryCode, this.countryName, this.languageId, this.ascii3CountryCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Country model) {
            if (model.wasPropertyExplicitlySet("countryId")) {
                this.countryId(model.getCountryId());
            }
            if (model.wasPropertyExplicitlySet("countryCode")) {
                this.countryCode(model.getCountryCode());
            }
            if (model.wasPropertyExplicitlySet("countryName")) {
                this.countryName(model.getCountryName());
            }
            if (model.wasPropertyExplicitlySet("languageId")) {
                this.languageId(model.getLanguageId());
            }
            if (model.wasPropertyExplicitlySet("ascii3CountryCode")) {
                this.ascii3CountryCode(model.getAscii3CountryCode());
            }
            return this;
        }
    }
}

