/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ospgateway.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BillingAddress
extends ExplicitlySetBmcModel {
    @JsonProperty(value="addressKey")
    private final String addressKey;
    @JsonProperty(value="line1")
    private final String line1;
    @JsonProperty(value="line2")
    private final String line2;
    @JsonProperty(value="city")
    private final String city;
    @JsonProperty(value="country")
    private final String country;
    @JsonProperty(value="postalCode")
    private final String postalCode;
    @JsonProperty(value="state")
    private final String state;
    @JsonProperty(value="emailAddress")
    private final String emailAddress;
    @JsonProperty(value="companyName")
    private final String companyName;
    @JsonProperty(value="firstName")
    private final String firstName;
    @JsonProperty(value="lastName")
    private final String lastName;

    @Deprecated
    @ConstructorProperties(value={"addressKey", "line1", "line2", "city", "country", "postalCode", "state", "emailAddress", "companyName", "firstName", "lastName"})
    public BillingAddress(String addressKey, String line1, String line2, String city, String country, String postalCode, String state, String emailAddress, String companyName, String firstName, String lastName) {
        this.addressKey = addressKey;
        this.line1 = line1;
        this.line2 = line2;
        this.city = city;
        this.country = country;
        this.postalCode = postalCode;
        this.state = state;
        this.emailAddress = emailAddress;
        this.companyName = companyName;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAddressKey() {
        return this.addressKey;
    }

    public String getLine1() {
        return this.line1;
    }

    public String getLine2() {
        return this.line2;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getState() {
        return this.state;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BillingAddress(");
        sb.append("super=").append(super.toString());
        sb.append("addressKey=").append(String.valueOf(this.addressKey));
        sb.append(", line1=").append(String.valueOf(this.line1));
        sb.append(", line2=").append(String.valueOf(this.line2));
        sb.append(", city=").append(String.valueOf(this.city));
        sb.append(", country=").append(String.valueOf(this.country));
        sb.append(", postalCode=").append(String.valueOf(this.postalCode));
        sb.append(", state=").append(String.valueOf(this.state));
        sb.append(", emailAddress=").append(String.valueOf(this.emailAddress));
        sb.append(", companyName=").append(String.valueOf(this.companyName));
        sb.append(", firstName=").append(String.valueOf(this.firstName));
        sb.append(", lastName=").append(String.valueOf(this.lastName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BillingAddress)) {
            return false;
        }
        BillingAddress other = (BillingAddress)((Object)o);
        return Objects.equals(this.addressKey, other.addressKey) && Objects.equals(this.line1, other.line1) && Objects.equals(this.line2, other.line2) && Objects.equals(this.city, other.city) && Objects.equals(this.country, other.country) && Objects.equals(this.postalCode, other.postalCode) && Objects.equals(this.state, other.state) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.companyName, other.companyName) && Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.addressKey == null ? 43 : this.addressKey.hashCode());
        result = result * 59 + (this.line1 == null ? 43 : this.line1.hashCode());
        result = result * 59 + (this.line2 == null ? 43 : this.line2.hashCode());
        result = result * 59 + (this.city == null ? 43 : this.city.hashCode());
        result = result * 59 + (this.country == null ? 43 : this.country.hashCode());
        result = result * 59 + (this.postalCode == null ? 43 : this.postalCode.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.emailAddress == null ? 43 : this.emailAddress.hashCode());
        result = result * 59 + (this.companyName == null ? 43 : this.companyName.hashCode());
        result = result * 59 + (this.firstName == null ? 43 : this.firstName.hashCode());
        result = result * 59 + (this.lastName == null ? 43 : this.lastName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="addressKey")
        private String addressKey;
        @JsonProperty(value="line1")
        private String line1;
        @JsonProperty(value="line2")
        private String line2;
        @JsonProperty(value="city")
        private String city;
        @JsonProperty(value="country")
        private String country;
        @JsonProperty(value="postalCode")
        private String postalCode;
        @JsonProperty(value="state")
        private String state;
        @JsonProperty(value="emailAddress")
        private String emailAddress;
        @JsonProperty(value="companyName")
        private String companyName;
        @JsonProperty(value="firstName")
        private String firstName;
        @JsonProperty(value="lastName")
        private String lastName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder addressKey(String addressKey) {
            this.addressKey = addressKey;
            this.__explicitlySet__.add("addressKey");
            return this;
        }

        public Builder line1(String line1) {
            this.line1 = line1;
            this.__explicitlySet__.add("line1");
            return this;
        }

        public Builder line2(String line2) {
            this.line2 = line2;
            this.__explicitlySet__.add("line2");
            return this;
        }

        public Builder city(String city) {
            this.city = city;
            this.__explicitlySet__.add("city");
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            this.__explicitlySet__.add("country");
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            this.__explicitlySet__.add("postalCode");
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.__explicitlySet__.add("emailAddress");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.__explicitlySet__.add("companyName");
            return this;
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            this.__explicitlySet__.add("firstName");
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            this.__explicitlySet__.add("lastName");
            return this;
        }

        public BillingAddress build() {
            BillingAddress model = new BillingAddress(this.addressKey, this.line1, this.line2, this.city, this.country, this.postalCode, this.state, this.emailAddress, this.companyName, this.firstName, this.lastName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BillingAddress model) {
            if (model.wasPropertyExplicitlySet("addressKey")) {
                this.addressKey(model.getAddressKey());
            }
            if (model.wasPropertyExplicitlySet("line1")) {
                this.line1(model.getLine1());
            }
            if (model.wasPropertyExplicitlySet("line2")) {
                this.line2(model.getLine2());
            }
            if (model.wasPropertyExplicitlySet("city")) {
                this.city(model.getCity());
            }
            if (model.wasPropertyExplicitlySet("country")) {
                this.country(model.getCountry());
            }
            if (model.wasPropertyExplicitlySet("postalCode")) {
                this.postalCode(model.getPostalCode());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("emailAddress")) {
                this.emailAddress(model.getEmailAddress());
            }
            if (model.wasPropertyExplicitlySet("companyName")) {
                this.companyName(model.getCompanyName());
            }
            if (model.wasPropertyExplicitlySet("firstName")) {
                this.firstName(model.getFirstName());
            }
            if (model.wasPropertyExplicitlySet("lastName")) {
                this.lastName(model.getLastName());
            }
            return this;
        }
    }
}

