/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.osmanagement.model.Id;
import com.oracle.bmc.osmanagement.model.IntervalTypes;
import com.oracle.bmc.osmanagement.model.LifecycleStates;
import com.oracle.bmc.osmanagement.model.OperationTypes;
import com.oracle.bmc.osmanagement.model.OsFamilies;
import com.oracle.bmc.osmanagement.model.PackageName;
import com.oracle.bmc.osmanagement.model.PackageUpdateTypes;
import com.oracle.bmc.osmanagement.model.ScheduleTypes;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ScheduledJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="scheduleType")
    private final ScheduleTypes scheduleType;
    @JsonProperty(value="timeNextExecution")
    private final Date timeNextExecution;
    @JsonProperty(value="timeLastExecution")
    private final Date timeLastExecution;
    @JsonProperty(value="intervalType")
    private final IntervalTypes intervalType;
    @JsonProperty(value="intervalValue")
    private final String intervalValue;
    @JsonProperty(value="managedInstances")
    private final List<Id> managedInstances;
    @JsonProperty(value="managedInstanceGroups")
    private final List<Id> managedInstanceGroups;
    @JsonProperty(value="operationType")
    private final OperationTypes operationType;
    @JsonProperty(value="updateType")
    private final PackageUpdateTypes updateType;
    @JsonProperty(value="packageNames")
    private final List<PackageName> packageNames;
    @JsonProperty(value="workRequests")
    private final List<Id> workRequests;
    @JsonProperty(value="lifecycleState")
    private final LifecycleStates lifecycleState;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="updateNames")
    private final List<String> updateNames;
    @JsonProperty(value="osFamily")
    private final OsFamilies osFamily;
    @JsonProperty(value="isRestricted")
    private final Boolean isRestricted;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "scheduleType", "timeNextExecution", "timeLastExecution", "intervalType", "intervalValue", "managedInstances", "managedInstanceGroups", "operationType", "updateType", "packageNames", "workRequests", "lifecycleState", "freeformTags", "definedTags", "updateNames", "osFamily", "isRestricted"})
    public ScheduledJob(String id, String compartmentId, String displayName, String description, ScheduleTypes scheduleType, Date timeNextExecution, Date timeLastExecution, IntervalTypes intervalType, String intervalValue, List<Id> managedInstances, List<Id> managedInstanceGroups, OperationTypes operationType, PackageUpdateTypes updateType, List<PackageName> packageNames, List<Id> workRequests, LifecycleStates lifecycleState, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<String> updateNames, OsFamilies osFamily, Boolean isRestricted) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.scheduleType = scheduleType;
        this.timeNextExecution = timeNextExecution;
        this.timeLastExecution = timeLastExecution;
        this.intervalType = intervalType;
        this.intervalValue = intervalValue;
        this.managedInstances = managedInstances;
        this.managedInstanceGroups = managedInstanceGroups;
        this.operationType = operationType;
        this.updateType = updateType;
        this.packageNames = packageNames;
        this.workRequests = workRequests;
        this.lifecycleState = lifecycleState;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.updateNames = updateNames;
        this.osFamily = osFamily;
        this.isRestricted = isRestricted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ScheduleTypes getScheduleType() {
        return this.scheduleType;
    }

    public Date getTimeNextExecution() {
        return this.timeNextExecution;
    }

    public Date getTimeLastExecution() {
        return this.timeLastExecution;
    }

    public IntervalTypes getIntervalType() {
        return this.intervalType;
    }

    public String getIntervalValue() {
        return this.intervalValue;
    }

    public List<Id> getManagedInstances() {
        return this.managedInstances;
    }

    public List<Id> getManagedInstanceGroups() {
        return this.managedInstanceGroups;
    }

    public OperationTypes getOperationType() {
        return this.operationType;
    }

    public PackageUpdateTypes getUpdateType() {
        return this.updateType;
    }

    public List<PackageName> getPackageNames() {
        return this.packageNames;
    }

    public List<Id> getWorkRequests() {
        return this.workRequests;
    }

    public LifecycleStates getLifecycleState() {
        return this.lifecycleState;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<String> getUpdateNames() {
        return this.updateNames;
    }

    public OsFamilies getOsFamily() {
        return this.osFamily;
    }

    public Boolean getIsRestricted() {
        return this.isRestricted;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduledJob(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", scheduleType=").append(String.valueOf((Object)this.scheduleType));
        sb.append(", timeNextExecution=").append(String.valueOf(this.timeNextExecution));
        sb.append(", timeLastExecution=").append(String.valueOf(this.timeLastExecution));
        sb.append(", intervalType=").append(String.valueOf((Object)this.intervalType));
        sb.append(", intervalValue=").append(String.valueOf(this.intervalValue));
        sb.append(", managedInstances=").append(String.valueOf(this.managedInstances));
        sb.append(", managedInstanceGroups=").append(String.valueOf(this.managedInstanceGroups));
        sb.append(", operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", updateType=").append(String.valueOf((Object)this.updateType));
        sb.append(", packageNames=").append(String.valueOf(this.packageNames));
        sb.append(", workRequests=").append(String.valueOf(this.workRequests));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", updateNames=").append(String.valueOf(this.updateNames));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", isRestricted=").append(String.valueOf(this.isRestricted));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledJob)) {
            return false;
        }
        ScheduledJob other = (ScheduledJob)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.scheduleType, (Object)other.scheduleType) && Objects.equals(this.timeNextExecution, other.timeNextExecution) && Objects.equals(this.timeLastExecution, other.timeLastExecution) && Objects.equals((Object)this.intervalType, (Object)other.intervalType) && Objects.equals(this.intervalValue, other.intervalValue) && Objects.equals(this.managedInstances, other.managedInstances) && Objects.equals(this.managedInstanceGroups, other.managedInstanceGroups) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.updateType, (Object)other.updateType) && Objects.equals(this.packageNames, other.packageNames) && Objects.equals(this.workRequests, other.workRequests) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.updateNames, other.updateNames) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals(this.isRestricted, other.isRestricted) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.scheduleType == null ? 43 : this.scheduleType.hashCode());
        result = result * 59 + (this.timeNextExecution == null ? 43 : this.timeNextExecution.hashCode());
        result = result * 59 + (this.timeLastExecution == null ? 43 : this.timeLastExecution.hashCode());
        result = result * 59 + (this.intervalType == null ? 43 : this.intervalType.hashCode());
        result = result * 59 + (this.intervalValue == null ? 43 : this.intervalValue.hashCode());
        result = result * 59 + (this.managedInstances == null ? 43 : this.managedInstances.hashCode());
        result = result * 59 + (this.managedInstanceGroups == null ? 43 : this.managedInstanceGroups.hashCode());
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.updateType == null ? 43 : this.updateType.hashCode());
        result = result * 59 + (this.packageNames == null ? 43 : this.packageNames.hashCode());
        result = result * 59 + (this.workRequests == null ? 43 : this.workRequests.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.updateNames == null ? 43 : this.updateNames.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.isRestricted == null ? 43 : this.isRestricted.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="scheduleType")
        private ScheduleTypes scheduleType;
        @JsonProperty(value="timeNextExecution")
        private Date timeNextExecution;
        @JsonProperty(value="timeLastExecution")
        private Date timeLastExecution;
        @JsonProperty(value="intervalType")
        private IntervalTypes intervalType;
        @JsonProperty(value="intervalValue")
        private String intervalValue;
        @JsonProperty(value="managedInstances")
        private List<Id> managedInstances;
        @JsonProperty(value="managedInstanceGroups")
        private List<Id> managedInstanceGroups;
        @JsonProperty(value="operationType")
        private OperationTypes operationType;
        @JsonProperty(value="updateType")
        private PackageUpdateTypes updateType;
        @JsonProperty(value="packageNames")
        private List<PackageName> packageNames;
        @JsonProperty(value="workRequests")
        private List<Id> workRequests;
        @JsonProperty(value="lifecycleState")
        private LifecycleStates lifecycleState;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="updateNames")
        private List<String> updateNames;
        @JsonProperty(value="osFamily")
        private OsFamilies osFamily;
        @JsonProperty(value="isRestricted")
        private Boolean isRestricted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder scheduleType(ScheduleTypes scheduleType) {
            this.scheduleType = scheduleType;
            this.__explicitlySet__.add("scheduleType");
            return this;
        }

        public Builder timeNextExecution(Date timeNextExecution) {
            this.timeNextExecution = timeNextExecution;
            this.__explicitlySet__.add("timeNextExecution");
            return this;
        }

        public Builder timeLastExecution(Date timeLastExecution) {
            this.timeLastExecution = timeLastExecution;
            this.__explicitlySet__.add("timeLastExecution");
            return this;
        }

        public Builder intervalType(IntervalTypes intervalType) {
            this.intervalType = intervalType;
            this.__explicitlySet__.add("intervalType");
            return this;
        }

        public Builder intervalValue(String intervalValue) {
            this.intervalValue = intervalValue;
            this.__explicitlySet__.add("intervalValue");
            return this;
        }

        public Builder managedInstances(List<Id> managedInstances) {
            this.managedInstances = managedInstances;
            this.__explicitlySet__.add("managedInstances");
            return this;
        }

        public Builder managedInstanceGroups(List<Id> managedInstanceGroups) {
            this.managedInstanceGroups = managedInstanceGroups;
            this.__explicitlySet__.add("managedInstanceGroups");
            return this;
        }

        public Builder operationType(OperationTypes operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder updateType(PackageUpdateTypes updateType) {
            this.updateType = updateType;
            this.__explicitlySet__.add("updateType");
            return this;
        }

        public Builder packageNames(List<PackageName> packageNames) {
            this.packageNames = packageNames;
            this.__explicitlySet__.add("packageNames");
            return this;
        }

        public Builder workRequests(List<Id> workRequests) {
            this.workRequests = workRequests;
            this.__explicitlySet__.add("workRequests");
            return this;
        }

        public Builder lifecycleState(LifecycleStates lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder updateNames(List<String> updateNames) {
            this.updateNames = updateNames;
            this.__explicitlySet__.add("updateNames");
            return this;
        }

        public Builder osFamily(OsFamilies osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            this.__explicitlySet__.add("isRestricted");
            return this;
        }

        public ScheduledJob build() {
            ScheduledJob model = new ScheduledJob(this.id, this.compartmentId, this.displayName, this.description, this.scheduleType, this.timeNextExecution, this.timeLastExecution, this.intervalType, this.intervalValue, this.managedInstances, this.managedInstanceGroups, this.operationType, this.updateType, this.packageNames, this.workRequests, this.lifecycleState, this.freeformTags, this.definedTags, this.updateNames, this.osFamily, this.isRestricted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ScheduledJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("scheduleType")) {
                this.scheduleType(model.getScheduleType());
            }
            if (model.wasPropertyExplicitlySet("timeNextExecution")) {
                this.timeNextExecution(model.getTimeNextExecution());
            }
            if (model.wasPropertyExplicitlySet("timeLastExecution")) {
                this.timeLastExecution(model.getTimeLastExecution());
            }
            if (model.wasPropertyExplicitlySet("intervalType")) {
                this.intervalType(model.getIntervalType());
            }
            if (model.wasPropertyExplicitlySet("intervalValue")) {
                this.intervalValue(model.getIntervalValue());
            }
            if (model.wasPropertyExplicitlySet("managedInstances")) {
                this.managedInstances(model.getManagedInstances());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceGroups")) {
                this.managedInstanceGroups(model.getManagedInstanceGroups());
            }
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("updateType")) {
                this.updateType(model.getUpdateType());
            }
            if (model.wasPropertyExplicitlySet("packageNames")) {
                this.packageNames(model.getPackageNames());
            }
            if (model.wasPropertyExplicitlySet("workRequests")) {
                this.workRequests(model.getWorkRequests());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("updateNames")) {
                this.updateNames(model.getUpdateNames());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("isRestricted")) {
                this.isRestricted(model.getIsRestricted());
            }
            return this;
        }
    }
}

