/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.osmanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.osmanagement.Event;
import com.oracle.bmc.osmanagement.EventAsyncClient;
import com.oracle.bmc.osmanagement.EventPaginators;
import com.oracle.bmc.osmanagement.model.EventCollection;
import com.oracle.bmc.osmanagement.model.EventReport;
import com.oracle.bmc.osmanagement.model.RelatedEventCollection;
import com.oracle.bmc.osmanagement.requests.DeleteEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventContentRequest;
import com.oracle.bmc.osmanagement.requests.GetEventReportRequest;
import com.oracle.bmc.osmanagement.requests.GetEventRequest;
import com.oracle.bmc.osmanagement.requests.ListEventsRequest;
import com.oracle.bmc.osmanagement.requests.ListRelatedEventsRequest;
import com.oracle.bmc.osmanagement.requests.UpdateEventRequest;
import com.oracle.bmc.osmanagement.requests.UploadEventContentRequest;
import com.oracle.bmc.osmanagement.responses.DeleteEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventContentResponse;
import com.oracle.bmc.osmanagement.responses.GetEventReportResponse;
import com.oracle.bmc.osmanagement.responses.GetEventResponse;
import com.oracle.bmc.osmanagement.responses.ListEventsResponse;
import com.oracle.bmc.osmanagement.responses.ListRelatedEventsResponse;
import com.oracle.bmc.osmanagement.responses.UpdateEventResponse;
import com.oracle.bmc.osmanagement.responses.UploadEventContentResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventClient
extends BaseSyncClient
implements Event {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EVENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://osms.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EventAsyncClient.class);
    private final EventPaginators paginators = new EventPaginators(this);

    private EventClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public DeleteEventContentResponse deleteEventContent(DeleteEventContentRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (DeleteEventContentResponse)this.clientCall(request, DeleteEventContentResponse::builder).logger(LOG, "deleteEventContent").serviceDetails("Event", "DeleteEventContent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/DeleteEventContent").method(Method.DELETE).requestBuilder(DeleteEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", DeleteEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEventResponse getEvent(GetEventRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetEventResponse)this.clientCall(request, GetEventResponse::builder).logger(LOG, "getEvent").serviceDetails("Event", "GetEvent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/GetEvent").method(Method.GET).requestBuilder(GetEventRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(com.oracle.bmc.osmanagement.model.Event.class, GetEventResponse.Builder::event).handleResponseHeaderString("etag", GetEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEventContentResponse getEventContent(GetEventContentRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetEventContentResponse)this.clientCall(request, GetEventContentResponse::builder).logger(LOG, "getEventContent").serviceDetails("Event", "GetEventContent", "").method(Method.GET).requestBuilder(GetEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InputStream.class, GetEventContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetEventContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEventReportResponse getEventReport(GetEventReportRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetEventReportResponse)this.clientCall(request, GetEventReportResponse::builder).logger(LOG, "getEventReport").serviceDetails("Event", "GetEventReport", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventReport/GetEventReport").method(Method.GET).requestBuilder(GetEventReportRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam("report").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EventReport.class, GetEventReportResponse.Builder::eventReport).handleResponseHeaderString("opc-request-id", GetEventReportResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListEventsResponse listEvents(ListEventsRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEventsResponse)this.clientCall(request, ListEventsResponse::builder).logger(LOG, "listEvents").serviceDetails("Event", "ListEvents", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventCollection/ListEvents").method(Method.GET).requestBuilder(ListEventsRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("eventId", (Object)request.getEventId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("eventType", (BmcEnum)request.getEventType()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EventCollection.class, ListEventsResponse.Builder::eventCollection).handleResponseHeaderString("opc-request-id", ListEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRelatedEventsResponse listRelatedEvents(ListRelatedEventsRequest request) {
        Objects.requireNonNull(request.getEventFingerprint(), "eventFingerprint is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRelatedEventsResponse)this.clientCall(request, ListRelatedEventsResponse::builder).logger(LOG, "listRelatedEvents").serviceDetails("Event", "ListRelatedEvents", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/RelatedEventCollection/ListRelatedEvents").method(Method.GET).requestBuilder(ListRelatedEventsRequest::builder).basePath("/20190801").appendPathParam("relatedEvents").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("latestTimestampLessThan", (Object)request.getLatestTimestampLessThan()).appendQueryParam("latestTimestampGreaterThanOrEqualTo", (Object)request.getLatestTimestampGreaterThanOrEqualTo()).appendQueryParam("eventFingerprint", (Object)request.getEventFingerprint()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RelatedEventCollection.class, ListRelatedEventsResponse.Builder::relatedEventCollection).handleResponseHeaderString("opc-request-id", ListRelatedEventsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRelatedEventsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateEventResponse updateEvent(UpdateEventRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getUpdateEventDetails(), "updateEventDetails is required");
        return (UpdateEventResponse)this.clientCall(request, UpdateEventResponse::builder).logger(LOG, "updateEvent").serviceDetails("Event", "UpdateEvent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/Event/UpdateEvent").method(Method.PUT).requestBuilder(UpdateEventRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(com.oracle.bmc.osmanagement.model.Event.class, UpdateEventResponse.Builder::event).handleResponseHeaderString("etag", UpdateEventResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEventResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UploadEventContentResponse uploadEventContent(UploadEventContentRequest request) {
        Validate.notBlank((String)request.getManagedInstanceId(), (String)"managedInstanceId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getEventId(), (String)"eventId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (UploadEventContentResponse)this.clientCall(request, UploadEventContentResponse::builder).logger(LOG, "uploadEventContent").serviceDetails("Event", "UploadEventContent", "https://docs.oracle.com/iaas/api/#/en/os-management/20190801/EventContent/UploadEventContent").method(Method.POST).requestBuilder(UploadEventContentRequest::builder).basePath("/20190801").appendPathParam("managedInstances").appendPathParam(request.getManagedInstanceId()).appendPathParam("events").appendPathParam(request.getEventId()).appendPathParam("content").appendPathParam("actions").appendPathParam("upload").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", UploadEventContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EventPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EventClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EventClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public EventClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EventClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EventClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EventClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EventClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

